/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.materials;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.materials.BookTemplate;
import fi.foyt.fni.persistence.model.materials.BookTemplate_;
import fi.foyt.fni.persistence.model.materials.Folder;
import fi.foyt.fni.persistence.model.materials.MaterialPublicity;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class BookTemplateDAO
extends GenericDAO<BookTemplate> {
    private static final long serialVersionUID = 1L;

    public BookTemplate create(User creator, Date created, User modifier, Date modified, Language language, Folder parentFolder, String urlName, String title, String data, String styles, String fonts, String pageTypes, String description, String iconUrl, MaterialPublicity publicity) {
        BookTemplate bookTemplate = new BookTemplate();
        bookTemplate.setCreated(created);
        bookTemplate.setCreator(creator);
        bookTemplate.setData(data);
        bookTemplate.setStyles(styles);
        bookTemplate.setFonts(fonts);
        bookTemplate.setPageTypes(pageTypes);
        bookTemplate.setIconUrl(iconUrl);
        bookTemplate.setDescription(description);
        bookTemplate.setLanguage(language);
        bookTemplate.setModified(modified);
        bookTemplate.setModifier(modifier);
        bookTemplate.setParentFolder(parentFolder);
        bookTemplate.setPublicity(publicity);
        bookTemplate.setTitle(title);
        bookTemplate.setUrlName(urlName);
        return this.persist(bookTemplate);
    }

    public List<BookTemplate> listByPublicity(MaterialPublicity publicity) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BookTemplate.class);
        Root root = criteria.from(BookTemplate.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(BookTemplate_.publicity), (Object)publicity)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public BookTemplate updateModifier(BookTemplate bookTemplate, User modifier) {
        bookTemplate.setModifier(modifier);
        return this.persist(bookTemplate);
    }

    public BookTemplate updateModified(BookTemplate bookTemplate, Date modified) {
        bookTemplate.setModified(modified);
        return this.persist(bookTemplate);
    }

    public BookTemplate updateData(BookTemplate bookTemplate, String data) {
        bookTemplate.setData(data);
        return this.persist(bookTemplate);
    }

    public BookTemplate updateStyles(BookTemplate bookTemplate, String styles) {
        bookTemplate.setStyles(styles);
        return this.persist(bookTemplate);
    }

    public BookTemplate updateFonts(BookTemplate bookTemplate, String fonts) {
        bookTemplate.setFonts(fonts);
        return this.persist(bookTemplate);
    }

    public BookTemplate updatePageTypes(BookTemplate bookTemplate, String pageTypes) {
        bookTemplate.setPageTypes(pageTypes);
        return this.persist(bookTemplate);
    }
}

