/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.illusion;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent;
import fi.foyt.fni.persistence.model.illusion.IllusionEventTemplate;
import fi.foyt.fni.persistence.model.illusion.IllusionEventTemplate_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class IllusionEventTemplateDAO
extends GenericDAO<IllusionEventTemplate> {
    private static final long serialVersionUID = 1L;

    public IllusionEventTemplate create(IllusionEvent event, String name, String data, Date modified) {
        IllusionEventTemplate illusionEventTemplate = new IllusionEventTemplate();
        illusionEventTemplate.setEvent(event);
        illusionEventTemplate.setName(name);
        illusionEventTemplate.setData(data);
        illusionEventTemplate.setModified(modified);
        return this.persist(illusionEventTemplate);
    }

    public IllusionEventTemplate findByEventAndName(IllusionEvent event, String name) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventTemplate.class);
        Root root = criteria.from(IllusionEventTemplate.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventTemplate_.event), (Object)event), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventTemplate_.name), (Object)name)));
        return (IllusionEventTemplate)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<IllusionEventTemplate> listByEvent(IllusionEvent event) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventTemplate.class);
        Root root = criteria.from(IllusionEventTemplate.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventTemplate_.event), (Object)event));
        return entityManager.createQuery(criteria).getResultList();
    }

    public IllusionEventTemplate updateName(IllusionEventTemplate template, String name) {
        template.setName(name);
        return this.persist(template);
    }

    public IllusionEventTemplate updateData(IllusionEventTemplate template, String data) {
        template.setData(data);
        return this.persist(template);
    }

    public IllusionEventTemplate updateModified(IllusionEventTemplate template, Date modified) {
        template.setModified(modified);
        return this.persist(template);
    }
}

