/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.illusion;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent;
import fi.foyt.fni.persistence.model.illusion.IllusionEventParticipant;
import fi.foyt.fni.persistence.model.illusion.IllusionEventParticipantRole;
import fi.foyt.fni.persistence.model.illusion.IllusionEventParticipant_;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class IllusionEventParticipantDAO
extends GenericDAO<IllusionEventParticipant> {
    private static final long serialVersionUID = 1L;

    public IllusionEventParticipant create(User user, IllusionEvent event, String displayName, IllusionEventParticipantRole role, Date created) {
        IllusionEventParticipant illusionEventParticipant = new IllusionEventParticipant();
        illusionEventParticipant.setEvent(event);
        illusionEventParticipant.setDisplayName(displayName);
        illusionEventParticipant.setRole(role);
        illusionEventParticipant.setUser(user);
        illusionEventParticipant.setCreated(created);
        return this.persist(illusionEventParticipant);
    }

    public IllusionEventParticipant findByEventAndUser(IllusionEvent event, User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventParticipant.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.event), (Object)event), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.user), (Object)user)));
        return (IllusionEventParticipant)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public IllusionEventParticipant findByEventAndAccessCode(IllusionEvent event, String accessCode) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventParticipant.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.event), (Object)event), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.accessCode), (Object)accessCode)));
        return (IllusionEventParticipant)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<IllusionEventParticipant> listByEvent(IllusionEvent event) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventParticipant.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.event), (Object)event));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<IllusionEventParticipant> listByEventAndRole(IllusionEvent event, IllusionEventParticipantRole role) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventParticipant.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.event), (Object)event), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.role), (Object)role)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<IllusionEventParticipant> listByUserAndRole(User user, IllusionEventParticipantRole role) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEventParticipant.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.role), (Object)role)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<IllusionEvent> listIllusionEventsByUserAndRole(User user, IllusionEventParticipantRole role, Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        Join eventJoin = root.join(IllusionEventParticipant_.event);
        criteria.select((Selection)root.get(IllusionEventParticipant_.event));
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.user), (Object)user), criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.role), (Object)role), criteriaBuilder.equal((Expression)eventJoin.get(IllusionEvent_.published), (Object)published)}));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByEventAndRole(IllusionEvent event, IllusionEventParticipantRole role) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(IllusionEventParticipant.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.event), (Object)event), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEventParticipant_.role), (Object)role)));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public IllusionEventParticipant updateRole(IllusionEventParticipant illusionEventParticipant, IllusionEventParticipantRole role) {
        illusionEventParticipant.setRole(role);
        return this.persist(illusionEventParticipant);
    }

    public IllusionEventParticipant updateDisplayName(IllusionEventParticipant illusionEventParticipant, String displayName) {
        illusionEventParticipant.setDisplayName(displayName);
        return this.persist(illusionEventParticipant);
    }

    public IllusionEventParticipant updateAccessCode(IllusionEventParticipant illusionEventParticipant, String accessCode) {
        illusionEventParticipant.setAccessCode(accessCode);
        return this.persist(illusionEventParticipant);
    }
}

