/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.illusion;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent;
import fi.foyt.fni.persistence.model.illusion.IllusionEventJoinMode;
import fi.foyt.fni.persistence.model.illusion.IllusionEventPaymentMode;
import fi.foyt.fni.persistence.model.illusion.IllusionEventType;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent_;
import fi.foyt.fni.persistence.model.materials.IllusionEventFolder;
import fi.foyt.fni.persistence.model.oauth.OAuthClient;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class IllusionEventDAO
extends GenericDAO<IllusionEvent> {
    private static final long serialVersionUID = 1L;

    public IllusionEvent create(String urlName, String name, String location, String description, String xmppRoom, IllusionEventFolder folder, IllusionEventJoinMode joinMode, Date created, Double signUpFee, String signUpFeeText, Currency signUpFeeCurrency, Date start, Date end, OAuthClient oAuthClient, Integer ageLimit, Boolean beginnerFriendly, String imageUrl, IllusionEventType type, Date signUpStartDate, Date signUpEndDate, Boolean published, ForumTopic forumTopic, IllusionEventPaymentMode paymentMode) {
        IllusionEvent illusionEvent = new IllusionEvent();
        illusionEvent.setName(name);
        illusionEvent.setDescription(description);
        illusionEvent.setUrlName(urlName);
        illusionEvent.setXmppRoom(xmppRoom);
        illusionEvent.setCreated(created);
        illusionEvent.setFolder(folder);
        illusionEvent.setJoinMode(joinMode);
        illusionEvent.setSignUpFee(signUpFee);
        illusionEvent.setSignUpFeeText(signUpFeeText);
        illusionEvent.setSignUpFeeCurrency(signUpFeeCurrency);
        illusionEvent.setLocation(location);
        illusionEvent.setStart(start);
        illusionEvent.setEnd(end);
        illusionEvent.setOAuthClient(oAuthClient);
        illusionEvent.setAgeLimit(ageLimit);
        illusionEvent.setBeginnerFriendly(beginnerFriendly);
        illusionEvent.setImageUrl(imageUrl);
        illusionEvent.setType(type);
        illusionEvent.setSignUpStartDate(signUpStartDate);
        illusionEvent.setSignUpEndDate(signUpEndDate);
        illusionEvent.setPublished(published);
        illusionEvent.setForumTopic(forumTopic);
        illusionEvent.setPaymentMode(paymentMode);
        return this.persist(illusionEvent);
    }

    public IllusionEvent findByUrlName(String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.urlName), (Object)urlName));
        return (IllusionEvent)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public IllusionEvent findByFolder(IllusionEventFolder folder) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.folder), (Object)folder));
        return (IllusionEvent)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public IllusionEvent findByDomain(String domain) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.domain), (Object)domain));
        return (IllusionEvent)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public IllusionEvent findByOAuthClient(OAuthClient oAuthClient) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.oAuthClient), (Object)oAuthClient));
        return (IllusionEvent)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public IllusionEvent findByForumTopic(ForumTopic forumTopic) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.forumTopic), (Object)forumTopic));
        return (IllusionEvent)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<IllusionEvent> listByDomainNotNull() {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.isNotNull((Expression)root.get(IllusionEvent_.domain)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<IllusionEvent> listByStartGEOrEndGEAndPublishedSortByStart(Date start, Date end, Boolean published, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.or((Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(IllusionEvent_.start), (Comparable)start), (Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(IllusionEvent_.end), (Comparable)end)), (Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.published), (Object)published)));
        criteria.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get(IllusionEvent_.start))});
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public List<IllusionEvent> listByStartLTAndEndLTAndPublishedSortByEndAndStart(Date start, Date end, Boolean published, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.lessThan((Expression)root.get(IllusionEvent_.start), (Comparable)start), criteriaBuilder.lessThan((Expression)root.get(IllusionEvent_.end), (Comparable)end), criteriaBuilder.equal((Expression)root.get(IllusionEvent_.published), (Object)published)}));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(IllusionEvent_.start)), criteriaBuilder.desc((Expression)root.get(IllusionEvent_.end))});
        TypedQuery query = entityManager.createQuery(criteria);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    public List<IllusionEvent> listByStartLEAndGEAndPublishedSortByEndAndStart(Date start, Date end, Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.lessThanOrEqualTo((Expression)root.get(IllusionEvent_.start), (Comparable)start), criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(IllusionEvent_.end), (Comparable)end), criteriaBuilder.equal((Expression)root.get(IllusionEvent_.published), (Object)published)}));
        TypedQuery query = entityManager.createQuery(criteria);
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(IllusionEvent_.start)), criteriaBuilder.desc((Expression)root.get(IllusionEvent_.end))});
        return query.getResultList();
    }

    public List<IllusionEvent> listByPublishedOrderByStartAndEnd(Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(IllusionEvent.class);
        Root root = criteria.from(IllusionEvent.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(IllusionEvent_.published), (Object)published));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(IllusionEvent_.start)), criteriaBuilder.desc((Expression)root.get(IllusionEvent_.end))});
        return entityManager.createQuery(criteria).getResultList();
    }

    public IllusionEvent updateName(IllusionEvent illusionEvent, String name) {
        illusionEvent.setName(name);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateJoinMode(IllusionEvent illusionEvent, IllusionEventJoinMode joinMode) {
        illusionEvent.setJoinMode(joinMode);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateSignUpFeeText(IllusionEvent illusionEvent, String signUpFeeText) {
        illusionEvent.setSignUpFeeText(signUpFeeText);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateSignUpFee(IllusionEvent illusionEvent, Double signUpFee) {
        illusionEvent.setSignUpFee(signUpFee);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateSignUpFeeCurrency(IllusionEvent illusionEvent, Currency signUpFeeCurrency) {
        illusionEvent.setSignUpFeeCurrency(signUpFeeCurrency);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateUrlName(IllusionEvent illusionEvent, String urlName) {
        illusionEvent.setUrlName(urlName);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateDescription(IllusionEvent illusionEvent, String description) {
        illusionEvent.setDescription(description);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateLocation(IllusionEvent illusionEvent, String location) {
        illusionEvent.setLocation(location);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateStart(IllusionEvent illusionEvent, Date start) {
        illusionEvent.setStart(start);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateEnd(IllusionEvent illusionEvent, Date end) {
        illusionEvent.setEnd(end);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateOAuthClient(IllusionEvent illusionEvent, OAuthClient oAuthClient) {
        illusionEvent.setOAuthClient(oAuthClient);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateDomain(IllusionEvent illusionEvent, String domain) {
        illusionEvent.setDomain(domain);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateBeginnerFriendly(IllusionEvent illusionEvent, Boolean beginnerFriendly) {
        illusionEvent.setBeginnerFriendly(beginnerFriendly);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateImageUrl(IllusionEvent illusionEvent, String imageUrl) {
        illusionEvent.setImageUrl(imageUrl);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateType(IllusionEvent illusionEvent, IllusionEventType type) {
        illusionEvent.setType(type);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateAgeLimit(IllusionEvent illusionEvent, Integer ageLimit) {
        illusionEvent.setAgeLimit(ageLimit);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateSignUpStartDate(IllusionEvent illusionEvent, Date signUpStartDate) {
        illusionEvent.setSignUpStartDate(signUpStartDate);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updateSignUpEndDate(IllusionEvent illusionEvent, Date signUpEndDate) {
        illusionEvent.setSignUpEndDate(signUpEndDate);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updatePublished(IllusionEvent illusionEvent, Boolean published) {
        illusionEvent.setPublished(published);
        return this.persist(illusionEvent);
    }

    public IllusionEvent updatePaymentMode(IllusionEvent illusionEvent, IllusionEventPaymentMode paymentMode) {
        illusionEvent.setPaymentMode(paymentMode);
        return this.persist(illusionEvent);
    }
}

