/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.Publication;
import fi.foyt.fni.persistence.model.gamelibrary.ShoppingCart;
import fi.foyt.fni.persistence.model.gamelibrary.ShoppingCartItem;
import fi.foyt.fni.persistence.model.gamelibrary.ShoppingCartItem_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ShoppingCartItemDAO
extends GenericDAO<ShoppingCartItem> {
    private static final long serialVersionUID = 1L;

    public ShoppingCartItem create(ShoppingCart cart, Publication publication, Integer count) {
        ShoppingCartItem shoppingCartItem = new ShoppingCartItem();
        shoppingCartItem.setCart(cart);
        shoppingCartItem.setCount(count);
        shoppingCartItem.setPublication(publication);
        this.getEntityManager().persist((Object)shoppingCartItem);
        return shoppingCartItem;
    }

    public List<ShoppingCartItem> listByCart(ShoppingCart cart) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ShoppingCartItem.class);
        Root root = criteria.from(ShoppingCartItem.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ShoppingCartItem_.cart), (Object)cart));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<ShoppingCartItem> listByCartAndPublication(ShoppingCart cart, Publication publication) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ShoppingCartItem.class);
        Root root = criteria.from(ShoppingCartItem.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ShoppingCartItem_.cart), (Object)cart));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<ShoppingCart> listShoppingCartsByPublication(Publication publication) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ShoppingCart.class);
        Root root = criteria.from(ShoppingCartItem.class);
        criteria.select((Selection)root.get(ShoppingCartItem_.cart)).distinct(true);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ShoppingCartItem_.publication), (Object)publication));
        return entityManager.createQuery(criteria).getResultList();
    }

    public ShoppingCartItem updateCount(ShoppingCartItem shoppingCartItem, Integer count) {
        shoppingCartItem.setCount(count);
        this.getEntityManager().persist((Object)shoppingCartItem);
        return shoppingCartItem;
    }
}

