/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.ShoppingCart;
import fi.foyt.fni.persistence.model.gamelibrary.ShoppingCart_;
import fi.foyt.fni.persistence.model.users.Address;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ShoppingCartDAO
extends GenericDAO<ShoppingCart> {
    private static final long serialVersionUID = 1L;

    public ShoppingCart create(User customer, String sessionId, String deliveryMethodId, Address deliveryAddress, Date created, Date modified) {
        ShoppingCart shoppingCart = new ShoppingCart();
        shoppingCart.setDeliveryMethodId(deliveryMethodId);
        shoppingCart.setCreated(created);
        shoppingCart.setCustomer(customer);
        shoppingCart.setSessionId(sessionId);
        shoppingCart.setDeliveryAddress(deliveryAddress);
        shoppingCart.setModified(modified);
        this.getEntityManager().persist((Object)shoppingCart);
        return shoppingCart;
    }

    public ShoppingCart findByCustomer(User customer) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ShoppingCart.class);
        Root root = criteria.from(ShoppingCart.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ShoppingCart_.customer), (Object)customer));
        return (ShoppingCart)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public ShoppingCart updateCustomer(ShoppingCart shoppingCart, User customer) {
        shoppingCart.setCustomer(customer);
        this.getEntityManager().persist((Object)shoppingCart);
        return shoppingCart;
    }
}

