/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.GameLibraryTag;
import fi.foyt.fni.persistence.model.gamelibrary.Publication;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationTag;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationTag_;
import fi.foyt.fni.persistence.model.gamelibrary.Publication_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class PublicationTagDAO
extends GenericDAO<PublicationTag> {
    private static final long serialVersionUID = 1L;

    public PublicationTag create(GameLibraryTag tag, Publication publication) {
        PublicationTag publicationTag = new PublicationTag();
        publicationTag.setPublication(publication);
        publicationTag.setTag(tag);
        this.getEntityManager().persist((Object)publicationTag);
        return publicationTag;
    }

    public PublicationTag findByPublicationAndTag(Publication publication, GameLibraryTag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationTag.class);
        Root root = criteria.from(PublicationTag.class);
        criteria.select((Selection)root);
        criteria.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(PublicationTag_.publication), (Object)publication), criteriaBuilder.equal((Expression)root.get(PublicationTag_.tag), (Object)tag)});
        return (PublicationTag)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<PublicationTag> listByPublication(Publication publication) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationTag.class);
        Root root = criteria.from(PublicationTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(PublicationTag_.publication), (Object)publication));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Publication> listPublicationsByGameLibraryTags(List<GameLibraryTag> gameLibaryTags) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Publication.class);
        Root root = criteria.from(PublicationTag.class);
        criteria.select((Selection)root.get(PublicationTag_.publication));
        criteria.where((Expression)root.get(PublicationTag_.tag).in(gameLibaryTags));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countPublicationsByTag(GameLibraryTag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(PublicationTag.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root.get(PublicationTag_.publication)));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(PublicationTag_.tag), (Object)tag));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public List<GameLibraryTag> listGameLibraryTagsByPublicationPublished(Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(GameLibraryTag.class);
        Root root = criteria.from(PublicationTag.class);
        Join join = root.join(PublicationTag_.publication);
        criteria.select((Selection)root.get(PublicationTag_.tag)).distinct(true);
        criteria.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)join.get(Publication_.published), (Object)published)}));
        return entityManager.createQuery(criteria).getResultList();
    }
}

