/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.gamelibrary.Publication;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationImage;
import fi.foyt.fni.persistence.model.gamelibrary.Publication_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class PublicationDAO
extends GenericDAO<Publication> {
    private static final long serialVersionUID = 1L;

    public Publication findByUrlName(String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Publication.class);
        Root root = criteria.from(Publication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Publication_.urlName), (Object)urlName));
        return (Publication)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<Publication> listByPublishedOrderByCreated(Boolean published, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Publication.class);
        Root root = criteria.from(Publication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Publication_.published), (Object)published));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(Publication_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<Publication> listByCreatorAndPublished(User creator, Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Publication.class);
        Root root = criteria.from(Publication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Publication_.creator), (Object)creator), (Expression)criteriaBuilder.equal((Expression)root.get(Publication_.published), (Object)published)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByCreatorAndPublished(User creator, Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(Publication.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(Publication_.creator), (Object)creator), (Expression)criteriaBuilder.equal((Expression)root.get(Publication_.published), (Object)published)));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public Publication updateName(Publication publication, String name) {
        publication.setName(name);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateUrlName(Publication publication, String urlName) {
        publication.setUrlName(urlName);
        return this.persist(publication);
    }

    public Publication updateDescription(Publication publication, String description) {
        publication.setDescription(description);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateDefaultImage(Publication publication, PublicationImage defaultImage) {
        publication.setDefaultImage(defaultImage);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updatePrice(Publication publication, Double price) {
        publication.setPrice(price);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updatePublished(Publication publication, Boolean published) {
        publication.setPublished(published);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateModified(Publication publication, Date modified) {
        publication.setModified(modified);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateModifier(Publication publication, User modifier) {
        publication.setModifier(modifier);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateWidth(Publication publication, Integer width) {
        publication.setWidth(width);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateHeight(Publication publication, Integer height) {
        publication.setHeight(height);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateDepth(Publication publication, Integer depth) {
        publication.setDepth(depth);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateWeight(Publication publication, Double weight) {
        publication.setWeight(weight);
        this.getEntityManager().persist((Object)publication);
        return publication;
    }

    public Publication updateForumTopic(Publication publication, ForumTopic forumTopic) {
        publication.setForumTopic(forumTopic);
        return this.persist(publication);
    }

    public Publication updateLanguage(Publication publication, Language language) {
        publication.setLanguage(language);
        return this.persist(publication);
    }
}

