/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.Publication;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationAuthor;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationAuthor_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class PublicationAuthorDAO
extends GenericDAO<PublicationAuthor> {
    private static final long serialVersionUID = 1L;

    public PublicationAuthor create(Publication publication, User author) {
        PublicationAuthor publicationAuthor = new PublicationAuthor();
        publicationAuthor.setAuthor(author);
        publicationAuthor.setPublication(publication);
        return this.persist(publicationAuthor);
    }

    public PublicationAuthor findByPublicationAndAuthor(Publication publication, User author) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationAuthor.class);
        Root root = criteria.from(PublicationAuthor.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.publication), (Object)publication), (Expression)criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.author), (Object)author)));
        return (PublicationAuthor)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<PublicationAuthor> listByPublication(Publication publication) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationAuthor.class);
        Root root = criteria.from(PublicationAuthor.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.publication), (Object)publication));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<PublicationAuthor> listByAuthor(User author) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationAuthor.class);
        Root root = criteria.from(PublicationAuthor.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.author), (Object)author));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Publication> listPublicationsByAuthor(User author) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Publication.class);
        Root root = criteria.from(PublicationAuthor.class);
        criteria.select((Selection)root.get(PublicationAuthor_.publication));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.author), (Object)author));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<PublicationAuthor> listByPublicationAndAuthorNotIn(Publication publication, List<User> authors) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(PublicationAuthor.class);
        Root root = criteria.from(PublicationAuthor.class);
        criteria.select((Selection)root);
        criteria.where(new Predicate[]{criteriaBuilder.equal((Expression)root.get(PublicationAuthor_.publication), (Object)publication), criteriaBuilder.not((Expression)root.get(PublicationAuthor_.author).in(authors))});
        return entityManager.createQuery(criteria).getResultList();
    }
}

