/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.Order;
import fi.foyt.fni.persistence.model.gamelibrary.OrderItem;
import fi.foyt.fni.persistence.model.gamelibrary.OrderItem_;
import fi.foyt.fni.persistence.model.gamelibrary.Publication;
import fi.foyt.fni.persistence.model.illusion.IllusionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class OrderItemDAO
extends GenericDAO<OrderItem> {
    private static final long serialVersionUID = 1L;

    public OrderItem create(Order order, Publication publication, IllusionEvent illusionEvent, String name, Double unitPrice, Integer count) {
        OrderItem orderItem = new OrderItem();
        orderItem.setCount(count);
        orderItem.setName(name);
        orderItem.setOrder(order);
        orderItem.setPublication(publication);
        orderItem.setIllusionEvent(illusionEvent);
        orderItem.setUnitPrice(unitPrice);
        this.getEntityManager().persist((Object)orderItem);
        return orderItem;
    }

    public List<OrderItem> listByOrder(Order order) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(OrderItem.class);
        Root root = criteria.from(OrderItem.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(OrderItem_.order), (Object)order));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<Order> listOrdersByPublication(Publication publication) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Order.class);
        Root root = criteria.from(OrderItem.class);
        criteria.select((Selection)root.get(OrderItem_.order)).distinct(true);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(OrderItem_.publication), (Object)publication));
        return entityManager.createQuery(criteria).getResultList();
    }
}

