/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.gamelibrary.Order;
import fi.foyt.fni.persistence.model.gamelibrary.OrderStatus;
import fi.foyt.fni.persistence.model.gamelibrary.OrderType;
import fi.foyt.fni.persistence.model.gamelibrary.Order_;
import fi.foyt.fni.persistence.model.users.Address;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class OrderDAO
extends GenericDAO<Order> {
    private static final long serialVersionUID = 1L;

    public Order create(User customer, String accessKey, String customerCompany, String customerEmail, String customerFirstName, String customerLastName, String customerMobile, String customerPhone, OrderStatus orderStatus, OrderType type, Double shippingCosts, String notes, Address deliveryAddress, Date created, Date canceled, Date paid, Date shipped, Date delivered) {
        Order order = new Order();
        order.setAccessKey(accessKey);
        order.setCanceled(canceled);
        order.setCreated(created);
        order.setCustomer(customer);
        order.setCustomerCompany(customerCompany);
        order.setCustomerEmail(customerEmail);
        order.setCustomerFirstName(customerFirstName);
        order.setCustomerLastName(customerLastName);
        order.setCustomerMobile(customerMobile);
        order.setCustomerPhone(customerPhone);
        order.setShipped(shipped);
        order.setDelivered(delivered);
        order.setDeliveryAddress(deliveryAddress);
        order.setNotes(notes);
        order.setOrderStatus(orderStatus);
        order.setType(type);
        order.setPaid(paid);
        order.setShippingCosts(shippingCosts);
        return this.persist(order);
    }

    public List<Order> listByOrderStatus(OrderStatus orderStatus) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Order.class);
        Root root = criteria.from(Order.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Order_.orderStatus), (Object)orderStatus));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Order updateOrderStatus(Order order, OrderStatus orderStatus) {
        order.setOrderStatus(orderStatus);
        return this.persist(order);
    }

    public Order updateShipped(Order order, Date shipped) {
        order.setShipped(shipped);
        return this.persist(order);
    }

    public Order updatePaid(Order order, Date paid) {
        order.setPaid(paid);
        return this.persist(order);
    }

    public Order updateCanceled(Order order, Date canceled) {
        order.setCanceled(canceled);
        return this.persist(order);
    }

    public Order updateDelivered(Order order, Date delivered) {
        order.setDelivered(delivered);
        return this.persist(order);
    }
}

