/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.gamelibrary;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.gamelibrary.BookPublication;
import fi.foyt.fni.persistence.model.gamelibrary.BookPublication_;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationFile;
import fi.foyt.fni.persistence.model.gamelibrary.PublicationImage;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class BookPublicationDAO
extends GenericDAO<BookPublication> {
    private static final long serialVersionUID = 1L;

    public BookPublication create(String name, String urlName, String description, Double price, Double authorsShare, PublicationImage defaultImage, Date created, User creator, Date modified, User modifier, Boolean published, Integer height, Integer width, Integer depth, Double weight, Integer numberOfPages, String license, ForumTopic forumTopic, Language language, Long downloadCount, Long printCount) {
        BookPublication bookPublication = new BookPublication();
        bookPublication.setCreated(created);
        bookPublication.setCreator(creator);
        bookPublication.setDefaultImage(defaultImage);
        bookPublication.setDescription(description);
        bookPublication.setModified(modified);
        bookPublication.setModifier(modifier);
        bookPublication.setName(name);
        bookPublication.setUrlName(urlName);
        bookPublication.setPrice(price);
        bookPublication.setAuthorsShare(authorsShare);
        bookPublication.setPublished(published);
        bookPublication.setHeight(height);
        bookPublication.setWidth(width);
        bookPublication.setDepth(depth);
        bookPublication.setWeight(weight);
        bookPublication.setNumberOfPages(numberOfPages);
        bookPublication.setLicense(license);
        bookPublication.setForumTopic(forumTopic);
        bookPublication.setLanguage(language);
        bookPublication.setDownloadCount(downloadCount);
        bookPublication.setPrintCount(printCount);
        this.getEntityManager().persist((Object)bookPublication);
        return bookPublication;
    }

    public List<BookPublication> listByPublished(Boolean published) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BookPublication.class);
        Root root = criteria.from(BookPublication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BookPublication_.published), (Object)published));
        return entityManager.createQuery(criteria).getResultList();
    }

    public BookPublication findByUrlName(String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BookPublication.class);
        Root root = criteria.from(BookPublication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BookPublication_.urlName), (Object)urlName));
        return (BookPublication)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<BookPublication> listByPublishedOrderByCreated(Boolean published, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BookPublication.class);
        Root root = criteria.from(BookPublication.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BookPublication_.published), (Object)published));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(BookPublication_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public BookPublication updateNumberOfPages(BookPublication bookPublication, Integer numberOfPages) {
        bookPublication.setNumberOfPages(numberOfPages);
        this.getEntityManager().persist((Object)bookPublication);
        return bookPublication;
    }

    public BookPublication updateDownlodableFile(BookPublication bookPublication, PublicationFile downloadableFile) {
        bookPublication.setDownloadableFile(downloadableFile);
        return this.persist(bookPublication);
    }

    public BookPublication updatePrintableFile(BookPublication bookPublication, PublicationFile printableFile) {
        bookPublication.setPrintableFile(printableFile);
        return this.persist(bookPublication);
    }

    public BookPublication updateDownloadCount(BookPublication bookPublication, Long downloadCount) {
        bookPublication.setDownloadCount(downloadCount);
        return this.persist(bookPublication);
    }

    public BookPublication updatePrintCount(BookPublication bookPublication, Long printCount) {
        bookPublication.setPrintCount(printCount);
        return this.persist(bookPublication);
    }

    public BookPublication updateAuthorsShare(BookPublication bookPublication, Double authorsShare) {
        bookPublication.setAuthorsShare(authorsShare);
        return this.persist(bookPublication);
    }

    public BookPublication updateLicense(BookPublication publication, String license) {
        publication.setLicense(license);
        return this.persist(publication);
    }
}

