/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.forum;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.forum.Forum;
import fi.foyt.fni.persistence.model.forum.ForumPost;
import fi.foyt.fni.persistence.model.forum.ForumPost_;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.forum.ForumTopic_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ForumTopicDAO
extends GenericDAO<ForumTopic> {
    private static final long serialVersionUID = 1L;

    public ForumTopic create(Forum forum, User author, Date created, Date modified, String urlName, String subject, Long views) {
        EntityManager entityManager = this.getEntityManager();
        ForumTopic forumTopic = new ForumTopic();
        forumTopic.setAuthor(author);
        forumTopic.setCreated(created);
        forumTopic.setForum(forum);
        forumTopic.setModified(modified);
        forumTopic.setSubject(subject);
        forumTopic.setUrlName(urlName);
        forumTopic.setViews(views);
        entityManager.persist((Object)forumTopic);
        return forumTopic;
    }

    public ForumTopic findByForumAndUrlName(Forum forum, String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumTopic.class);
        Root root = criteria.from(ForumTopic.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(ForumTopic_.urlName), (Object)urlName), (Expression)criteriaBuilder.equal((Expression)root.get(ForumTopic_.forum), (Object)forum)));
        return (ForumTopic)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<ForumTopic> listByForum(Forum forum) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumTopic.class);
        Root root = criteria.from(ForumTopic.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumTopic_.forum), (Object)forum));
        return entityManager.createQuery(criteria).getResultList();
    }

    public Long countByForum(Forum forum) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ForumTopic.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumTopic_.forum), (Object)forum));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public ForumTopic updateViews(ForumTopic forumTopic, Long views) {
        EntityManager entityManager = this.getEntityManager();
        forumTopic.setViews(views);
        entityManager.persist((Object)forumTopic);
        return forumTopic;
    }

    public List<ForumTopic> listAllSortByAuthorMessageCount(User author, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumTopic.class);
        Root root = criteria.from(ForumPost.class);
        root.join(ForumPost_.topic);
        criteria.select((Selection)root.get(ForumPost_.topic));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.author), (Object)author));
        criteria.groupBy(new Expression[]{root.get(ForumPost_.topic)});
        criteria.orderBy(new Order[]{criteriaBuilder.desc(criteriaBuilder.count((Expression)root.get(ForumPost_.id)))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }
}

