/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.forum;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.forum.Forum;
import fi.foyt.fni.persistence.model.forum.ForumPost;
import fi.foyt.fni.persistence.model.forum.ForumPost_;
import fi.foyt.fni.persistence.model.forum.ForumTopic;
import fi.foyt.fni.persistence.model.forum.ForumTopic_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ForumPostDAO
extends GenericDAO<ForumPost> {
    private static final long serialVersionUID = 1L;

    public ForumPost create(ForumTopic topic, User author, Date created, Date modified, String content, Long views) {
        EntityManager entityManager = this.getEntityManager();
        ForumPost forumPost = new ForumPost();
        forumPost.setAuthor(author);
        forumPost.setCreated(created);
        forumPost.setTopic(topic);
        forumPost.setModified(modified);
        forumPost.setContent(content);
        forumPost.setViews(views);
        entityManager.persist((Object)forumPost);
        return forumPost;
    }

    public List<ForumPost> listByTopic(ForumTopic topic) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumPost.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.topic), (Object)topic));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<ForumPost> listByTopic(ForumTopic topic, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumPost.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.topic), (Object)topic));
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult.intValue());
        query.setMaxResults(maxResults.intValue());
        return query.getResultList();
    }

    public List<ForumPost> listByTopicSortByCreated(ForumTopic topic, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumPost.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.topic), (Object)topic));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(ForumPost_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult.intValue());
        query.setMaxResults(maxResults.intValue());
        return query.getResultList();
    }

    public List<ForumPost> listByForumSortByCreated(Forum forum, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumPost.class);
        Root root = criteria.from(ForumPost.class);
        Join topicJoin = root.join(ForumPost_.topic);
        criteria.select((Selection)root);
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(ForumPost_.created))});
        criteria.where((Expression)criteriaBuilder.equal((Expression)topicJoin.join(ForumTopic_.forum), (Object)forum));
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult.intValue());
        query.setMaxResults(maxResults.intValue());
        return query.getResultList();
    }

    public List<ForumPost> listByAuthorSortByCreated(User author, int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumPost.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)root);
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(ForumPost_.created))});
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.author), (Object)author));
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<ForumTopic> listTopicsSortByCreated(int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumTopic.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)root.get(ForumPost_.topic));
        criteria.orderBy(new Order[]{criteriaBuilder.desc(criteriaBuilder.greatest((Expression)root.get(ForumPost_.created)))});
        criteria.groupBy(new Expression[]{root.get(ForumPost_.topic)});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<ForumTopic> listTopicsByForumSortByCreated(Forum forum, Integer firstResult, Integer maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(ForumTopic.class);
        Root root = criteria.from(ForumPost.class);
        Join topicJoin = root.join(ForumPost_.topic);
        criteria.select((Selection)root.get(ForumPost_.topic));
        criteria.groupBy(new Expression[]{root.get(ForumPost_.topic)});
        criteria.orderBy(new Order[]{criteriaBuilder.desc(criteriaBuilder.greatest((Expression)root.get(ForumPost_.created)))});
        criteria.where((Expression)criteriaBuilder.equal((Expression)topicJoin.get(ForumTopic_.forum), (Object)forum));
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult.intValue());
        query.setMaxResults(maxResults.intValue());
        return query.getResultList();
    }

    public Long countByTopic(ForumTopic topic) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.topic), (Object)topic));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public Long countByAuthor(User author) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.author), (Object)author));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public Long countByTopicAndAuthor(ForumTopic topic, User author) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ForumPost.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.author), (Object)author), (Expression)criteriaBuilder.equal((Expression)root.get(ForumPost_.topic), (Object)topic)));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public Long countByForum(Forum forum) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(ForumPost.class);
        Join topicJoin = root.join(ForumPost_.topic);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.equal((Expression)topicJoin.join(ForumTopic_.forum), (Object)forum));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public ForumPost updateViews(ForumPost forumPost, Long views) {
        EntityManager entityManager = this.getEntityManager();
        forumPost.setViews(views);
        entityManager.persist((Object)forumPost);
        return forumPost;
    }

    public ForumPost updateContent(ForumPost forumPost, String content) {
        forumPost.setContent(content);
        return this.persist(forumPost);
    }

    public ForumPost updateModified(ForumPost forumPost, Date modified) {
        forumPost.setModified(modified);
        return this.persist(forumPost);
    }
}

