/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.forum;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.forum.Forum;
import fi.foyt.fni.persistence.model.forum.ForumCategory;
import fi.foyt.fni.persistence.model.forum.Forum_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class ForumDAO
extends GenericDAO<Forum> {
    private static final long serialVersionUID = 1L;

    public Forum create(String name, String urlName, String description, ForumCategory forumCategory, Boolean allowTopicCreation) {
        EntityManager entityManager = this.getEntityManager();
        Forum forum = new Forum();
        forum.setName(name);
        forum.setUrlName(urlName);
        forum.setCategory(forumCategory);
        forum.setDescription(description);
        forum.setAllowTopicCreation(allowTopicCreation);
        entityManager.persist((Object)forum);
        return forum;
    }

    public Forum findByName(String name) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Forum.class);
        Root root = criteria.from(Forum.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Forum_.name), (Object)name));
        return (Forum)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public Forum findByUrlName(String urlName) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Forum.class);
        Root root = criteria.from(Forum.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Forum_.urlName), (Object)urlName));
        return (Forum)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<Forum> listByCategory(ForumCategory category) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Forum.class);
        Root root = criteria.from(Forum.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Forum_.category), (Object)category));
        return entityManager.createQuery(criteria).getResultList();
    }
}

