/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.common;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.common.Language;
import fi.foyt.fni.persistence.model.common.Language_;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class LanguageDAO
extends GenericDAO<Language> {
    private static final long serialVersionUID = 1L;

    public Language create(String iso2, String iso3) {
        EntityManager entityManager = this.getEntityManager();
        Language language = new Language();
        language.setISO2(iso2);
        language.setISO3(iso3);
        entityManager.persist((Object)language);
        return language;
    }

    public Language findByIso2(String iso2) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Language.class);
        Root root = criteria.from(Language.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Language_.ISO2), (Object)iso2));
        return (Language)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public Language findByIso3(String iso3) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Language.class);
        Root root = criteria.from(Language.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Language_.ISO3), (Object)iso3));
        return (Language)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<Language> listByLocalized(Boolean localized) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Language.class);
        Root root = criteria.from(Language.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(Language_.localized), (Object)localized));
        return entityManager.createQuery(criteria).getResultList();
    }
}

