/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.blog;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.blog.BlogEntry;
import fi.foyt.fni.persistence.model.blog.BlogEntryTag;
import fi.foyt.fni.persistence.model.blog.BlogEntryTag_;
import fi.foyt.fni.persistence.model.blog.BlogTag;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class BlogEntryTagDAO
extends GenericDAO<BlogEntryTag> {
    private static final long serialVersionUID = 1L;

    public BlogEntryTag create(BlogEntry entry, BlogTag tag) {
        BlogEntryTag blogEntryTag = new BlogEntryTag();
        blogEntryTag.setEntry(entry);
        blogEntryTag.setTag(tag);
        this.getEntityManager().persist((Object)blogEntryTag);
        return blogEntryTag;
    }

    public BlogEntryTag findByEntryAndTag(BlogEntry entry, BlogTag tag) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntryTag.class);
        Root root = criteria.from(BlogEntryTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(BlogEntryTag_.entry), (Object)entry), (Expression)criteriaBuilder.equal((Expression)root.get(BlogEntryTag_.tag), (Object)tag)));
        return (BlogEntryTag)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<BlogTag> listTagsByBlogEntry(BlogEntry entry) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogTag.class);
        Root root = criteria.from(BlogEntryTag.class);
        criteria.select((Selection)root.get(BlogEntryTag_.tag));
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BlogEntryTag_.entry), (Object)entry));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<BlogEntryTag> listByEntryAndTagNotIn(BlogEntry entry, List<BlogTag> blogTags) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntryTag.class);
        Root root = criteria.from(BlogEntryTag.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(BlogEntryTag_.entry), (Object)entry), (Expression)criteriaBuilder.not((Expression)root.get(BlogEntryTag_.tag).in(blogTags))));
        return entityManager.createQuery(criteria).getResultList();
    }
}

