/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.blog;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.blog.BlogCategory;
import fi.foyt.fni.persistence.model.blog.BlogEntry;
import fi.foyt.fni.persistence.model.blog.BlogEntry_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class BlogEntryDAO
extends GenericDAO<BlogEntry> {
    private static final long serialVersionUID = 1L;

    public BlogEntry create(String guid, BlogCategory category, String urlName, String authorName, String link, String title, String summary, String content, Date modified, User modifier, Date created, User creator) {
        BlogEntry blogEntry = new BlogEntry();
        blogEntry.setGuid(guid);
        blogEntry.setAuthorName(authorName);
        blogEntry.setLink(link);
        blogEntry.setTitle(title);
        blogEntry.setSummary(summary);
        blogEntry.setContent(content);
        blogEntry.setCategory(category);
        blogEntry.setModified(modified);
        blogEntry.setModifier(modifier);
        blogEntry.setCreated(created);
        blogEntry.setCreator(creator);
        blogEntry.setUrlName(urlName);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }

    public BlogEntry findByGuid(String guid) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntry.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BlogEntry_.guid), (Object)guid));
        return (BlogEntry)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<BlogEntry> listByCategory(BlogCategory category) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntry.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(BlogEntry_.category), (Object)category));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<BlogEntry> listAllSortByCreated(int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntry.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)root);
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(BlogEntry_.created))});
        TypedQuery query = entityManager.createQuery(criteria);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public List<BlogEntry> listByCreatedGreaterOrEqualAndCreatedLessOrEqualSortByCreated(Date greater, Date less) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogEntry.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(BlogEntry_.created), (Comparable)greater), (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get(BlogEntry_.created), (Comparable)less)));
        criteria.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get(BlogEntry_.created))});
        return entityManager.createQuery(criteria).getResultList();
    }

    public Date minBlogDate() {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Date.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)criteriaBuilder.least((Expression)root.get(BlogEntry_.created)));
        return (Date)entityManager.createQuery(criteria).getSingleResult();
    }

    public Date maxBlogDate() {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Date.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)criteriaBuilder.greatest((Expression)root.get(BlogEntry_.created)));
        return (Date)entityManager.createQuery(criteria).getSingleResult();
    }

    public Long countByCreatedGreaterOrEqualAndCreatedLessOrEqualSortByCreated(Date greater, Date less) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(Long.class);
        Root root = criteria.from(BlogEntry.class);
        criteria.select((Selection)criteriaBuilder.count((Expression)root));
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(BlogEntry_.created), (Comparable)greater), (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get(BlogEntry_.created), (Comparable)less)));
        return (Long)entityManager.createQuery(criteria).getSingleResult();
    }

    public BlogEntry updateAuthorName(BlogEntry blogEntry, String authorName) {
        blogEntry.setAuthorName(authorName);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }

    public BlogEntry updateLink(BlogEntry blogEntry, String link) {
        blogEntry.setLink(link);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }

    public BlogEntry updateTitle(BlogEntry blogEntry, String title) {
        blogEntry.setTitle(title);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }

    public BlogEntry updateSummary(BlogEntry blogEntry, String summary) {
        blogEntry.setSummary(summary);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }

    public BlogEntry updateModified(BlogEntry blogEntry, Date modified) {
        blogEntry.setModified(modified);
        this.getEntityManager().persist((Object)blogEntry);
        return blogEntry;
    }
}

