/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.blog;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.blog.BlogCategory;
import fi.foyt.fni.persistence.model.blog.BlogCategorySync;
import fi.foyt.fni.persistence.model.blog.BlogCategory_;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class BlogCategoryDAO
extends GenericDAO<BlogCategory> {
    private static final long serialVersionUID = 1L;

    public BlogCategory create(String name, String syncUrl, BlogCategorySync sync, Date nextSync) {
        BlogCategory blogCategory = new BlogCategory();
        blogCategory.setName(name);
        blogCategory.setNextSync(nextSync);
        blogCategory.setSync(sync);
        blogCategory.setSyncUrl(syncUrl);
        this.getEntityManager().persist((Object)blogCategory);
        return blogCategory;
    }

    public List<BlogCategory> listBySyncNeNullAndNextSyncLe(Date nextSync) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(BlogCategory.class);
        Root root = criteria.from(BlogCategory.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.isNotNull((Expression)root.get(BlogCategory_.sync)), (Expression)criteriaBuilder.lessThanOrEqualTo((Expression)root.get(BlogCategory_.nextSync), (Comparable)nextSync)));
        return entityManager.createQuery(criteria).getResultList();
    }

    public BlogCategory updateNextSync(BlogCategory blogCategory, Date nextSync) {
        blogCategory.setNextSync(nextSync);
        this.getEntityManager().persist((Object)blogCategory);
        return blogCategory;
    }
}

