/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao.auth;

import fi.foyt.fni.persistence.dao.GenericDAO;
import fi.foyt.fni.persistence.model.auth.AuthSource;
import fi.foyt.fni.persistence.model.auth.UserIdentifier;
import fi.foyt.fni.persistence.model.auth.UserIdentifier_;
import fi.foyt.fni.persistence.model.users.User;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class UserIdentifierDAO
extends GenericDAO<UserIdentifier> {
    private static final long serialVersionUID = 1L;

    public UserIdentifier create(User user, AuthSource authSource, String sourceId, String identifier) {
        EntityManager entityManager = this.getEntityManager();
        UserIdentifier userIdentifier = new UserIdentifier();
        userIdentifier.setIdentifier(identifier);
        userIdentifier.setUser(user);
        userIdentifier.setAuthSource(authSource);
        userIdentifier.setSourceId(sourceId);
        entityManager.persist((Object)userIdentifier);
        return userIdentifier;
    }

    public UserIdentifier findByAuthSourceAndIdentifier(AuthSource authSource, String identifier) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserIdentifier.class);
        Root root = criteria.from(UserIdentifier.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserIdentifier_.identifier), (Object)identifier), (Expression)criteriaBuilder.equal((Expression)root.get(UserIdentifier_.authSource), (Object)authSource)));
        return (UserIdentifier)this.getSingleResult((Query)entityManager.createQuery(criteria));
    }

    public List<UserIdentifier> listByUser(User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserIdentifier.class);
        Root root = criteria.from(UserIdentifier.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(UserIdentifier_.user), (Object)user));
        return entityManager.createQuery(criteria).getResultList();
    }

    public List<UserIdentifier> listByAuthSourceAndUser(AuthSource authSource, User user) {
        EntityManager entityManager = this.getEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = criteriaBuilder.createQuery(UserIdentifier.class);
        Root root = criteria.from(UserIdentifier.class);
        criteria.select((Selection)root);
        criteria.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(UserIdentifier_.user), (Object)user), (Expression)criteriaBuilder.equal((Expression)root.get(UserIdentifier_.authSource), (Object)authSource)));
        return entityManager.createQuery(criteria).getResultList();
    }
}

