/*
 * Decompiled with CFR 0.152.
 */
package fi.foyt.fni.persistence.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class GenericDAO<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @PersistenceContext
    private EntityManager entityManager;

    public T findById(Long id) {
        EntityManager entityManager = this.getEntityManager();
        return (T)entityManager.find(this.getGenericTypeClass(), (Object)id);
    }

    public List<T> listAll() {
        EntityManager entityManager = this.getEntityManager();
        Class<?> genericTypeClass = this.getGenericTypeClass();
        Query query = entityManager.createQuery("select o from " + genericTypeClass.getName() + " o");
        return query.getResultList();
    }

    public List<T> listAll(int firstResult, int maxResults) {
        EntityManager entityManager = this.getEntityManager();
        Class<?> genericTypeClass = this.getGenericTypeClass();
        Query query = entityManager.createQuery("select o from " + genericTypeClass.getName() + " o");
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResults);
        return query.getResultList();
    }

    public Integer count() {
        EntityManager entityManager = this.getEntityManager();
        Class<?> genericTypeClass = this.getGenericTypeClass();
        Query query = entityManager.createQuery("select count(o) from " + genericTypeClass.getName() + " o");
        return (Integer)query.getSingleResult();
    }

    public void delete(T o) {
        EntityManager entityManager = this.getEntityManager();
        entityManager.remove(entityManager.merge(o));
    }

    private Class<?> getGenericTypeClass() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    protected T getSingleResult(Query query) {
        List list = query.getResultList();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        throw new NonUniqueResultException("SingleResult query returned " + list.size() + " elements");
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected T persist(T entity) {
        this.getEntityManager().persist(entity);
        return entity;
    }
}

