/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBlockType;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamp;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;

public class BasicTimestampValidationCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final TimestampWrapper timestamp;
    private final XmlValidationProcessTimestamp timestampValidationResult;

    public BasicTimestampValidationCheck(I18nProvider i18nProvider, T result, TimestampWrapper timestamp, XmlValidationProcessTimestamp timestampValidationResult, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, timestamp.getId());
        this.timestamp = timestamp;
        this.timestampValidationResult = timestampValidationResult;
    }

    @Override
    protected XmlBlockType getBlockType() {
        return XmlBlockType.TST_BBB;
    }

    @Override
    protected boolean process() {
        return this.isValid((XmlConstraintsConclusion)this.timestampValidationResult);
    }

    @Override
    protected String buildAdditionalInfo() {
        String date = ValidationProcessUtils.getFormattedDate(this.timestamp.getProductionTime());
        return this.i18nProvider.getMessage(MessageTag.TIMESTAMP_VALIDATION, new Object[]{ValidationProcessUtils.getTimestampTypeMessageTag(this.timestamp.getType()), this.timestamp.getId(), date});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.ADEST_IBSVPTC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.ADEST_IBSVPTC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.timestampValidationResult.getConclusion().getSubIndication();
    }
}

