/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class ByteRangeAllDocumentCheck
extends ChainItem<XmlFC> {
    private final DiagnosticData diagnosticData;

    public ByteRangeAllDocumentCheck(I18nProvider i18nProvider, XmlFC result, DiagnosticData diagnosticData, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.diagnosticData = diagnosticData;
    }

    @Override
    protected boolean process() {
        for (SignatureWrapper signature : this.diagnosticData.getSignatures()) {
            if (signature.getPDFRevision() == null || signature.isSignatureByteRangeValid()) continue;
            return false;
        }
        for (TimestampWrapper timestamp : this.diagnosticData.getTimestampList()) {
            if (timestamp.getPDFRevision() == null || timestamp.isSignatureByteRangeValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_DASTHVBR;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_DASTHVBR_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

