/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.jaxb.common.XSDAbstractUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespace;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.xades.XAdES111Utils;
import eu.europa.esig.xades.XAdES122Utils;
import eu.europa.esig.xades.XAdES319132Utils;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;

public class XAdESStructureValidator {
    private final Element signatureElement;
    private final XAdESPath xadesPath;
    private List<String> errors;

    protected XAdESStructureValidator(Element signatureElement, XAdESPath xadesPath) {
        this.signatureElement = signatureElement;
        this.xadesPath = xadesPath;
    }

    public boolean validate() {
        this.errors = DSSXMLUtils.validateAgainstXSD(this.getUtils(this.xadesPath), new DOMSource(this.signatureElement));
        return Utils.isCollectionEmpty(this.errors);
    }

    public List<String> getValidationErrors() {
        if (this.errors == null) {
            throw new IllegalStateException("The method XAdESStructureValidator#validate shall be executed before accessing the validation messages!");
        }
        return this.errors;
    }

    protected XSDAbstractUtils getUtils(XAdESPath xadesPath) {
        DSSNamespace namespace = xadesPath.getNamespace();
        if (XAdESNamespace.XADES_111 == namespace) {
            return XAdES111Utils.getInstance();
        }
        if (XAdESNamespace.XADES_122 == namespace) {
            return XAdES122Utils.getInstance();
        }
        if (XAdESNamespace.XADES_132 == namespace || XAdESNamespace.XADES_141 == namespace) {
            return XAdES319132Utils.getInstance();
        }
        throw new UnsupportedOperationException(String.format("The namespace '%s' is not supported for structure validation!", namespace.getUri()));
    }
}

