/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverContext;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CounterSignatureResolver
extends ResourceResolverSpi {
    private final DSSDocument document;

    public CounterSignatureResolver(DSSDocument document) {
        this.document = document;
    }

    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        String uriValue = this.getURIValue(context);
        Node node = this.resolveNode(uriValue);
        if (node != null) {
            return this.createFromNode(node);
        }
        Object[] exArgs = new Object[]{String.format("Unable to find a signed content by URI : '%s'", uriValue)};
        throw new ResourceResolverException("generic.EmptyMessage", exArgs, null, context.baseUri);
    }

    private XMLSignatureInput createFromNode(Node node) {
        XMLSignatureInput result = new XMLSignatureInput(DomUtils.serializeNode((Node)node));
        result.setMIMEType(MimeTypeEnum.XML.getMimeTypeString());
        return result;
    }

    private boolean isXPointerSlash(String uri) {
        return uri.equals("#xpointer(/)");
    }

    public boolean engineCanResolveURI(ResourceResolverContext context) {
        String uriValue = this.getURIValue(context);
        return (DomUtils.isXPointerQuery((String)uriValue) || DomUtils.isElementReference((String)uriValue)) && this.resolveNode(uriValue) != null;
    }

    private String getURIValue(ResourceResolverContext context) {
        Attr uriAttr = context.attr;
        if (uriAttr == null) {
            return null;
        }
        return DSSUtils.decodeURI((String)uriAttr.getNodeValue());
    }

    private Node resolveNode(String uriValue) {
        if (uriValue == null) {
            return null;
        }
        Document documentDom = DomUtils.buildDOM((DSSDocument)this.document);
        Node node = DomUtils.getNode((Node)documentDom, (String)(XMLDSigPath.ALL_SIGNATURE_VALUES_PATH + DomUtils.getXPathByIdAttribute((String)uriValue)));
        if (node == null && this.isXPointerSlash(uriValue) && XMLDSigElement.SIGNATURE_VALUE.getTagName().equals(documentDom.getLocalName())) {
            node = documentDom;
        } else if (node == null && DomUtils.isXPointerQuery((String)uriValue)) {
            String xPointerId = DomUtils.getXPointerId((String)uriValue);
            node = DomUtils.getNode((Node)documentDom, (String)(XMLDSigPath.ALL_SIGNATURE_VALUES_PATH + DomUtils.getXPathByIdAttribute((String)xPointerId)));
        }
        if (node != null) {
            return node;
        }
        return null;
    }
}

