/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;

public class ReferenceIdProvider {
    private XAdESSignatureParameters signatureParameters;
    private String referenceIdPrefix = "r";
    private int index;

    public void setSignatureParameters(XAdESSignatureParameters signatureParameters) {
        this.signatureParameters = signatureParameters;
    }

    public void setReferenceIdPrefix(String referenceIdPrefix) {
        if (Utils.isStringBlank((String)referenceIdPrefix)) {
            throw new IllegalArgumentException("The reference id prefix cannot be blank!");
        }
        this.referenceIdPrefix = referenceIdPrefix;
    }

    public String getReferenceId() {
        this.increaseIndex();
        StringBuilder referenceId = new StringBuilder();
        referenceId.append(this.referenceIdPrefix);
        referenceId.append("-");
        if (this.signatureParameters != null) {
            referenceId.append(this.signatureParameters.getDeterministicId());
            referenceId.append("-");
        }
        referenceId.append(this.index);
        return referenceId.toString();
    }

    private void increaseIndex() {
        ++this.index;
    }
}

