/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sync;

import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import eu.europa.esig.dss.model.tsl.TrustService;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TrustServiceProviderBuilder {
    private Map<String, List<String>> names;
    private Map<String, List<String>> tradeNames;
    private List<String> registrationIdentifiers;
    private Map<String, String> postalAddresses;
    private Map<String, List<String>> electronicAddresses;
    private Map<String, String> information;
    private List<TrustService> services;
    private String territory;

    public TrustServiceProviderBuilder() {
    }

    public TrustServiceProviderBuilder(TrustServiceProvider original) {
        Objects.requireNonNull(original, "TrustServiceProvider cannot be null!");
        this.names = original.getNames();
        this.tradeNames = original.getTradeNames();
        this.registrationIdentifiers = original.getRegistrationIdentifiers();
        this.postalAddresses = original.getPostalAddresses();
        this.electronicAddresses = original.getElectronicAddresses();
        this.information = original.getInformation();
        this.services = original.getServices();
        this.territory = original.getTerritory();
    }

    public TrustServiceProvider build() {
        TrustServiceProvider trustServiceProvider = new TrustServiceProvider();
        trustServiceProvider.setNames(this.getNames());
        trustServiceProvider.setTradeNames(this.getTradeNames());
        trustServiceProvider.setRegistrationIdentifiers(this.getRegistrationIdentifiers());
        trustServiceProvider.setPostalAddresses(this.getPostalAddresses());
        trustServiceProvider.setElectronicAddresses(this.getElectronicAddresses());
        trustServiceProvider.setInformation(this.getInformation());
        trustServiceProvider.setServices(this.getServices());
        trustServiceProvider.setTerritory(this.getTerritory());
        return trustServiceProvider;
    }

    public Map<String, List<String>> getNames() {
        return this.getUnmodifiableMapWithLists(this.names);
    }

    public TrustServiceProviderBuilder setNames(Map<String, List<String>> names) {
        this.names = names;
        return this;
    }

    public Map<String, List<String>> getTradeNames() {
        return this.getUnmodifiableMapWithLists(this.tradeNames);
    }

    public TrustServiceProviderBuilder setTradeNames(Map<String, List<String>> tradeNames) {
        this.tradeNames = tradeNames;
        return this;
    }

    public List<String> getRegistrationIdentifiers() {
        return this.getUnmodifiableList(this.registrationIdentifiers);
    }

    public TrustServiceProviderBuilder setRegistrationIdentifiers(List<String> registrationIdentifiers) {
        this.registrationIdentifiers = registrationIdentifiers;
        return this;
    }

    public Map<String, String> getPostalAddresses() {
        return this.getUnmodifiableMap(this.postalAddresses);
    }

    public TrustServiceProviderBuilder setPostalAddresses(Map<String, String> postalAddresses) {
        this.postalAddresses = postalAddresses;
        return this;
    }

    public Map<String, List<String>> getElectronicAddresses() {
        return this.getUnmodifiableMapWithLists(this.electronicAddresses);
    }

    public TrustServiceProviderBuilder setElectronicAddresses(Map<String, List<String>> electronicAddresses) {
        this.electronicAddresses = electronicAddresses;
        return this;
    }

    public Map<String, String> getInformation() {
        return this.getUnmodifiableMap(this.information);
    }

    public TrustServiceProviderBuilder setInformation(Map<String, String> information) {
        this.information = information;
        return this;
    }

    public List<TrustService> getServices() {
        return this.getUnmodifiableTrustServices(this.services);
    }

    public TrustServiceProviderBuilder setServices(List<TrustService> services) {
        this.services = services;
        return this;
    }

    public String getTerritory() {
        return this.territory;
    }

    public TrustServiceProviderBuilder setTerritory(String territory) {
        this.territory = territory;
        return this;
    }

    private <T> List<T> getUnmodifiableList(List<T> originalList) {
        ArrayList<T> newList = new ArrayList<T>();
        if (originalList != null && !originalList.isEmpty()) {
            newList.addAll(originalList);
        }
        return Collections.unmodifiableList(newList);
    }

    private <T, K> Map<T, K> getUnmodifiableMap(Map<T, K> originalMap) {
        HashMap<T, K> newMap = new HashMap<T, K>();
        if (originalMap != null && !originalMap.isEmpty()) {
            newMap.putAll(originalMap);
        }
        return Collections.unmodifiableMap(newMap);
    }

    private Map<String, List<String>> getUnmodifiableMapWithLists(Map<String, List<String>> originalMap) {
        HashMap<String, List<String>> copyMap = new HashMap<String, List<String>>();
        if (originalMap != null && !originalMap.isEmpty()) {
            for (Map.Entry<String, List<String>> mapEntry : originalMap.entrySet()) {
                copyMap.put(mapEntry.getKey(), Collections.unmodifiableList(mapEntry.getValue()));
            }
        }
        return Collections.unmodifiableMap(copyMap);
    }

    private List<TrustService> getUnmodifiableTrustServices(List<TrustService> originalTrustServices) {
        ArrayList<TrustService> copyTrustServices = new ArrayList<TrustService>();
        if (originalTrustServices != null && !originalTrustServices.isEmpty()) {
            for (TrustService trustService : originalTrustServices) {
                TrustService.TrustServiceBuilder trustServiceBuilder = new TrustService.TrustServiceBuilder();
                TrustService copyTrustService = trustServiceBuilder.setCertificates(this.getUnmodifiableList(trustService.getCertificates())).setStatusAndInformationExtensions(this.getUnmodifiableTimeDependentValues((TimeDependentValues<TrustServiceStatusAndInformationExtensions>)trustService.getStatusAndInformationExtensions())).build();
                copyTrustServices.add(copyTrustService);
            }
        }
        return Collections.unmodifiableList(copyTrustServices);
    }

    private TimeDependentValues<TrustServiceStatusAndInformationExtensions> getUnmodifiableTimeDependentValues(TimeDependentValues<TrustServiceStatusAndInformationExtensions> timeDependentValues) {
        ArrayList<TrustServiceStatusAndInformationExtensions> copyTSSAndIEs = new ArrayList<TrustServiceStatusAndInformationExtensions>();
        for (TrustServiceStatusAndInformationExtensions status : timeDependentValues) {
            TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder builder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
            TrustServiceStatusAndInformationExtensions copyStatus = builder.setNames(this.getUnmodifiableMapWithLists(status.getNames())).setType(status.getType()).setStatus(status.getStatus()).setConditionsForQualifiers(this.getUnmodifiableList(status.getConditionsForQualifiers())).setAdditionalServiceInfoUris(this.getUnmodifiableList(status.getAdditionalServiceInfoUris())).setServiceSupplyPoints(this.getUnmodifiableList(status.getServiceSupplyPoints())).setExpiredCertsRevocationInfo(status.getExpiredCertsRevocationInfo()).setStartDate(status.getStartDate()).setEndDate(status.getEndDate()).build();
            copyTSSAndIEs.add(copyStatus);
        }
        return new TimeDependentValues(copyTSSAndIEs);
    }
}

