/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.parsing;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.tsl.function.NonEmptyServiceInformation;
import eu.europa.esig.dss.tsl.function.NonEmptyTSPInformation;
import eu.europa.esig.dss.tsl.function.NonEmptyTrustService;
import eu.europa.esig.dss.tsl.function.converter.TrustServiceProviderConverter;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingTask;
import eu.europa.esig.dss.tsl.parsing.TLParsingResult;
import eu.europa.esig.dss.tsl.source.TLSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.tsl.TSLSchemeInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServicesListType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPType;
import eu.europa.esig.trustedlist.jaxb.tsl.TrustServiceProviderListType;
import eu.europa.esig.trustedlist.jaxb.tsl.TrustStatusListType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TLParsingTask
extends AbstractParsingTask<TLParsingResult> {
    private final TLSource tlSource;

    public TLParsingTask(DSSDocument document, TLSource tlSource) {
        super(document);
        Objects.requireNonNull(tlSource, "The TLSource is null");
        this.tlSource = tlSource;
    }

    @Override
    public TLParsingResult get() {
        TLParsingResult result = new TLParsingResult();
        TrustStatusListType jaxbObject = this.getJAXBObject();
        this.parseSchemeInformation(result, jaxbObject.getSchemeInformation());
        this.parseTrustServiceProviderList(result, jaxbObject.getTrustServiceProviderList());
        this.verifyTLVersionConformity(result, result.getVersion(), this.tlSource.getTLVersions());
        return result;
    }

    private void parseSchemeInformation(TLParsingResult result, TSLSchemeInformationType schemeInformation) {
        this.commonParseSchemeInformation(result, schemeInformation);
    }

    private void parseTrustServiceProviderList(TLParsingResult result, TrustServiceProviderListType trustServiceProviderList) {
        if (trustServiceProviderList != null && Utils.isCollectionNotEmpty((Collection)trustServiceProviderList.getTrustServiceProvider())) {
            List<TSPType> filteredTrustServiceProviders = this.filter(trustServiceProviderList.getTrustServiceProvider());
            result.setTrustServiceProviders(Collections.unmodifiableList(filteredTrustServiceProviders.stream().map(new TrustServiceProviderConverter().setTerritory(result.getTerritory())).collect(Collectors.toList())));
        } else {
            result.setTrustServiceProviders(Collections.emptyList());
        }
    }

    private List<TSPType> filter(List<TSPType> trustServiceProviders) {
        List<Object> filteredTSP = trustServiceProviders;
        filteredTSP = filteredTSP.stream().filter(new NonEmptyTSPInformation()).collect(Collectors.toList());
        if (this.tlSource.getTrustServiceProviderPredicate() != null) {
            filteredTSP = filteredTSP.stream().filter(this.tlSource.getTrustServiceProviderPredicate()).collect(Collectors.toList());
        }
        for (TSPType tspType : filteredTSP) {
            TSPServicesListType tspServices = tspType.getTSPServices();
            if (tspServices == null || !Utils.isCollectionNotEmpty((Collection)tspServices.getTSPService())) continue;
            List filteredTrustServices = tspServices.getTSPService().stream().filter(new NonEmptyServiceInformation()).collect(Collectors.toList());
            if (this.tlSource.getTrustServicePredicate() != null) {
                filteredTrustServices = filteredTrustServices.stream().filter(this.tlSource.getTrustServicePredicate()).collect(Collectors.toList());
            }
            TSPServicesListType newTspServices = new TSPServicesListType();
            if (!filteredTrustServices.isEmpty()) {
                newTspServices.getTSPService().addAll(filteredTrustServices);
            }
            tspType.setTSPServices(newTspServices);
        }
        return filteredTSP.stream().filter(new NonEmptyTrustService()).collect(Collectors.toList());
    }
}

