/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function.converter;

import eu.europa.esig.dss.model.timedependent.MutableTimeDependentValues;
import eu.europa.esig.dss.model.timedependent.TimeDependent;
import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.model.tsl.TrustService;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.tsl.function.converter.CriteriaListConverter;
import eu.europa.esig.dss.tsl.function.converter.DigitalIdentityListTypeConverter;
import eu.europa.esig.dss.tsl.function.converter.InternationalNamesTypeConverter;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.jaxb.ecc.QualificationElementType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualificationsType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifierType;
import eu.europa.esig.trustedlist.jaxb.ecc.QualifiersType;
import eu.europa.esig.trustedlist.jaxb.tsl.AdditionalServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.AttributedNonEmptyURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.DigitalIdentityListType;
import eu.europa.esig.trustedlist.jaxb.tsl.ExtensionType;
import eu.europa.esig.trustedlist.jaxb.tsl.ExtensionsListType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceHistoryInstanceType;
import eu.europa.esig.trustedlist.jaxb.tsl.ServiceSupplyPointsType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSPServiceType;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustServiceConverter
implements Function<TSPServiceType, TrustService> {
    private static final Logger LOG = LoggerFactory.getLogger(TrustServiceConverter.class);

    @Override
    public TrustService apply(TSPServiceType original) {
        TrustService.TrustServiceBuilder trustServiceBuilder = new TrustService.TrustServiceBuilder();
        if (original.getServiceInformation() != null) {
            trustServiceBuilder.setCertificates(this.extractCertificates(original.getServiceInformation())).setStatusAndInformationExtensions(this.extractStatusAndHistory(original));
        } else {
            LOG.warn("No mandatory TSPServiceInformation element found within TSPService element!");
        }
        return trustServiceBuilder.build();
    }

    private List<CertificateToken> extractCertificates(TSPServiceInformationType serviceInformation) {
        DigitalIdentityListTypeConverter converter = new DigitalIdentityListTypeConverter();
        DigitalIdentityListType serviceDigitalIdentityList = serviceInformation.getServiceDigitalIdentity();
        return Collections.unmodifiableList(converter.apply(serviceDigitalIdentityList));
    }

    private TimeDependentValues<TrustServiceStatusAndInformationExtensions> extractStatusAndHistory(TSPServiceType original) {
        MutableTimeDependentValues statusHistoryList = new MutableTimeDependentValues();
        TSPServiceInformationType serviceInfo = original.getServiceInformation();
        InternationalNamesTypeConverter converter = new InternationalNamesTypeConverter();
        TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusBuilder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
        statusBuilder.setNames(converter.apply(serviceInfo.getServiceName()));
        statusBuilder.setType(serviceInfo.getServiceTypeIdentifier());
        statusBuilder.setStatus(serviceInfo.getServiceStatus());
        statusBuilder.setServiceSupplyPoints(this.getServiceSupplyPoints(serviceInfo.getServiceSupplyPoints()));
        this.parseExtensionsList(serviceInfo.getServiceInformationExtensions(), statusBuilder);
        Date nextEndDate = this.convertToDate(serviceInfo.getStatusStartingTime());
        statusBuilder.setStartDate(nextEndDate);
        statusHistoryList.addOldest((TimeDependent)statusBuilder.build());
        if (original.getServiceHistory() != null && Utils.isCollectionNotEmpty((Collection)original.getServiceHistory().getServiceHistoryInstance())) {
            for (ServiceHistoryInstanceType serviceHistory : original.getServiceHistory().getServiceHistoryInstance()) {
                if (serviceHistory.getStatusStartingTime() == null) {
                    LOG.warn("No StatusStartingTime is found within a ServiceHistoryInstance element. The entry is skipped.");
                    continue;
                }
                TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusHistoryBuilder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
                statusHistoryBuilder.setNames(converter.apply(serviceHistory.getServiceName()));
                statusHistoryBuilder.setType(serviceHistory.getServiceTypeIdentifier());
                statusHistoryBuilder.setStatus(serviceHistory.getServiceStatus());
                this.parseExtensionsList(serviceHistory.getServiceInformationExtensions(), statusHistoryBuilder);
                statusHistoryBuilder.setEndDate(nextEndDate);
                nextEndDate = this.convertToDate(serviceHistory.getStatusStartingTime());
                statusHistoryBuilder.setStartDate(nextEndDate);
                statusHistoryList.addOldest((TimeDependent)statusHistoryBuilder.build());
            }
        }
        return statusHistoryList;
    }

    private void parseExtensionsList(ExtensionsListType serviceInformationExtensions, TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder statusBuilder) {
        if (serviceInformationExtensions != null) {
            statusBuilder.setConditionsForQualifiers(this.extractConditionsForQualifiers(serviceInformationExtensions.getExtension()));
            statusBuilder.setAdditionalServiceInfoUris(this.extractAdditionalServiceInfoUris(serviceInformationExtensions.getExtension()));
            statusBuilder.setExpiredCertsRevocationInfo(this.extractExpiredCertsRevocationInfo(serviceInformationExtensions.getExtension()));
        }
    }

    private List<ConditionForQualifiers> extractConditionsForQualifiers(List<ExtensionType> extensions) {
        ArrayList<ConditionForQualifiers> conditionsForQualifiersList = new ArrayList<ConditionForQualifiers>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                QualificationsType qualifications;
                List<ConditionForQualifiers> conditionForQualifiers;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof QualificationsType) || !Utils.isCollectionNotEmpty(conditionForQualifiers = this.toConditionForQualificationsType(qualifications = (QualificationsType)jaxbElement.getValue(), extensionType.isCritical()))) continue;
                conditionsForQualifiersList.addAll(conditionForQualifiers);
            }
        }
        return conditionsForQualifiersList;
    }

    private List<ConditionForQualifiers> toConditionForQualificationsType(QualificationsType qt, boolean critical) {
        ArrayList<ConditionForQualifiers> conditionForQualifiers = new ArrayList<ConditionForQualifiers>();
        if (qt != null && Utils.isCollectionNotEmpty((Collection)qt.getQualificationElement())) {
            for (QualificationElementType qualificationElement : qt.getQualificationElement()) {
                ConditionForQualifiers condition = this.toConditionForQualifiers(qualificationElement, critical);
                if (condition == null) continue;
                conditionForQualifiers.add(condition);
            }
        }
        return conditionForQualifiers;
    }

    private ConditionForQualifiers toConditionForQualifiers(QualificationElementType qualificationElement, boolean critical) {
        List<String> qualifiers = this.extractQualifiers(qualificationElement);
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            Condition condition = new CriteriaListConverter().apply(qualificationElement.getCriteriaList());
            return new ConditionForQualifiers(condition, Collections.unmodifiableList(qualifiers), critical);
        }
        return null;
    }

    private List<String> extractAdditionalServiceInfoUris(List<ExtensionType> extensions) {
        ArrayList<String> additionalServiceInfos = new ArrayList<String>();
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                AdditionalServiceInformationType additionalServiceInfo;
                NonEmptyMultiLangURIType uri;
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof AdditionalServiceInformationType) || (uri = (additionalServiceInfo = (AdditionalServiceInformationType)objectValue).getURI()) == null || !Utils.isStringNotBlank((String)uri.getValue())) continue;
                additionalServiceInfos.add(uri.getValue());
            }
        }
        return additionalServiceInfos;
    }

    private Date extractExpiredCertsRevocationInfo(List<ExtensionType> extensions) {
        for (ExtensionType extensionType : extensions) {
            List content = extensionType.getContent();
            if (!Utils.isCollectionNotEmpty((Collection)content)) continue;
            for (Object object : content) {
                JAXBElement jaxbElement;
                Object objectValue;
                if (!(object instanceof JAXBElement) || !((objectValue = (jaxbElement = (JAXBElement)object).getValue()) instanceof XMLGregorianCalendar)) continue;
                return this.convertToDate((XMLGregorianCalendar)objectValue);
            }
        }
        return null;
    }

    private Date convertToDate(XMLGregorianCalendar gregorianCalendar) {
        if (gregorianCalendar != null) {
            return gregorianCalendar.toGregorianCalendar().getTime();
        }
        return null;
    }

    private List<String> extractQualifiers(QualificationElementType qualificationElement) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        QualifiersType qualifiersType = qualificationElement.getQualifiers();
        if (qualifiersType != null && Utils.isCollectionNotEmpty((Collection)qualifiersType.getQualifier())) {
            for (QualifierType qualitierType : qualifiersType.getQualifier()) {
                qualifiers.add(qualitierType.getUri());
            }
        }
        return qualifiers;
    }

    private List<String> getServiceSupplyPoints(ServiceSupplyPointsType serviceSupplyPoints) {
        ArrayList<String> result = new ArrayList<String>();
        if (serviceSupplyPoints != null && Utils.isCollectionNotEmpty((Collection)serviceSupplyPoints.getServiceSupplyPoint())) {
            for (AttributedNonEmptyURIType nonEmptyURI : serviceSupplyPoints.getServiceSupplyPoint()) {
                result.add(nonEmptyURI.getValue());
            }
        }
        return result;
    }
}

