/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.function;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.tsl.function.LOTLSigningCertificatesAnnouncementSchemeInformationURI;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public class OfficialJournalSchemeInformationURI
implements LOTLSigningCertificatesAnnouncementSchemeInformationURI {
    private final String officialJournalURL;

    public OfficialJournalSchemeInformationURI(String officialJournalURL) {
        Objects.requireNonNull(officialJournalURL, "Official Journal URL cannot be null!");
        this.officialJournalURL = officialJournalURL;
    }

    @Override
    public boolean test(NonEmptyMultiLangURIType t) {
        if (t != null && t.getValue() != null) {
            return t.getValue().contains(this.getOJDomain());
        }
        return false;
    }

    private String getOJDomain() {
        try {
            URL uri = URI.create(this.officialJournalURL).toURL();
            return uri.getHost();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            throw new DSSException("Incorrect format of Official Journal URL [" + this.officialJournalURL + "] is provided", (Throwable)e);
        }
    }

    @Override
    public String getUri() {
        return this.officialJournalURL;
    }
}

