/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.condition;

import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicies;
import eu.europa.esig.dss.model.x509.extension.CertificatePolicy;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import java.util.Objects;

public class PolicyIdCondition
implements Condition {
    private static final long serialVersionUID = 7590885101177874819L;
    private final String policyOid;

    public PolicyIdCondition(String policyId) {
        Objects.requireNonNull(policyId, "Policy Id must be defined");
        this.policyOid = policyId;
    }

    public final String getPolicyOid() {
        return this.policyOid;
    }

    public boolean check(CertificateToken certificateToken) {
        Objects.requireNonNull(certificateToken, "Certificate cannot be null");
        CertificatePolicies certificatePolicies = CertificateExtensionsUtils.getCertificatePolicies((CertificateToken)certificateToken);
        if (certificatePolicies != null) {
            for (CertificatePolicy certificatePolicy : certificatePolicies.getPolicyList()) {
                if (!this.policyOid.equals(certificatePolicy.getOid())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append("PolicyIdCondition: ").append(this.policyOid).append('\n');
        return builder.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

