/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.dto.builder;

import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;
import eu.europa.esig.dss.tsl.dto.builder.AbstractCacheDTOBuilder;
import eu.europa.esig.dss.tsl.validation.ValidationResult;
import java.util.Date;
import java.util.List;

public class ValidationCacheDTOBuilder
extends AbstractCacheDTOBuilder<ValidationResult> {
    public ValidationCacheDTOBuilder(CachedEntry<ValidationResult> cachedEntry) {
        super(cachedEntry);
    }

    @Override
    public ValidationCacheDTO build() {
        ValidationCacheDTO validationCacheDTO = new ValidationCacheDTO(super.build());
        if (this.isResultExist()) {
            validationCacheDTO.setIndication(this.getIndication());
            validationCacheDTO.setSubIndication(this.getSubIndication());
            validationCacheDTO.setSigningTime(this.getSigningTime());
            validationCacheDTO.setSigningCertificate(this.getSigningCertificate());
            validationCacheDTO.setPotentialSigners(this.getPotentialSigners());
        }
        return validationCacheDTO;
    }

    private Indication getIndication() {
        return ((ValidationResult)this.getResult()).getIndication();
    }

    private SubIndication getSubIndication() {
        return ((ValidationResult)this.getResult()).getSubIndication();
    }

    private Date getSigningTime() {
        return ((ValidationResult)this.getResult()).getSigningTime();
    }

    private CertificateToken getSigningCertificate() {
        return ((ValidationResult)this.getResult()).getSigningCertificate();
    }

    private List<CertificateToken> getPotentialSigners() {
        return ((ValidationResult)this.getResult()).getPotentialSigners();
    }
}

