/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.access;

import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.DownloadCache;
import eu.europa.esig.dss.tsl.cache.ParsingCache;
import eu.europa.esig.dss.tsl.cache.ValidationCache;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.cache.access.DebugCacheAccess;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.cache.access.SynchronizerCacheAccess;
import eu.europa.esig.dss.tsl.cache.access.TLChangesCacheAccess;

public final class CacheAccessFactory {
    private final DownloadCache downloadCache = new DownloadCache();
    private final ParsingCache parsingCache = new ParsingCache();
    private final ValidationCache validationCache = new ValidationCache();

    public CacheAccessByKey getCacheAccess(CacheKey key) {
        return new CacheAccessByKey(key, this.downloadCache, this.parsingCache, this.validationCache);
    }

    public TLChangesCacheAccess getTLChangesCacheAccess() {
        return new TLChangesCacheAccess(this.downloadCache, this.parsingCache, this.validationCache);
    }

    public ReadOnlyCacheAccess getReadOnlyCacheAccess() {
        return new ReadOnlyCacheAccess(this.downloadCache, this.parsingCache, this.validationCache);
    }

    public SynchronizerCacheAccess getSynchronizerCacheAccess() {
        return new SynchronizerCacheAccess(this.downloadCache, this.parsingCache, this.validationCache);
    }

    public DebugCacheAccess getDebugCacheAccess() {
        return new DebugCacheAccess(this.downloadCache, this.parsingCache, this.validationCache);
    }
}

