/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.model.DSSException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Provider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SunPKCS11Initializer {
    private static final String SUN_PKCS11_CLASSNAME = "sun.security.pkcs11.SunPKCS11";

    private SunPKCS11Initializer() {
    }

    public static Provider getProvider(String configString) {
        Provider provider;
        ByteArrayInputStream bais = new ByteArrayInputStream(configString.getBytes());
        try {
            Class<?> sunPkcs11ProviderClass = Class.forName(SUN_PKCS11_CLASSNAME);
            Constructor<?> constructor = sunPkcs11ProviderClass.getConstructor(InputStream.class);
            provider = (Provider)constructor.newInstance(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DSSException("Unable to instantiate PKCS11 (JDK < 9) ", (Throwable)e);
            }
        }
        bais.close();
        return provider;
    }
}

