/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.MultipleRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ListRevocationSource<R extends Revocation>
implements MultipleRevocationSource<R> {
    private static final long serialVersionUID = -6284731668494875108L;
    private List<OfflineRevocationSource<R>> sources = new ArrayList<OfflineRevocationSource<R>>();

    public ListRevocationSource() {
    }

    public ListRevocationSource(OfflineRevocationSource<R> revocationSource) {
        this.add(revocationSource);
    }

    public boolean add(OfflineRevocationSource<R> revocationSource) {
        if (revocationSource != null && !this.sources.contains(revocationSource)) {
            return this.sources.add(revocationSource);
        }
        return false;
    }

    public void addAll(ListRevocationSource<R> listRevocationSource) {
        this.addAll(listRevocationSource.getSources());
    }

    public void addAll(List<OfflineRevocationSource<R>> revocationSources) {
        this.sources.addAll(revocationSources);
    }

    public List<OfflineRevocationSource<R>> getSources() {
        return this.sources;
    }

    public boolean isEmpty() {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            if (revocationSource.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<RevocationToken<R>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        HashSet allTokens = new HashSet();
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            allTokens.addAll(revocationSource.getRevocationTokens(certificateToken, issuerCertificateToken));
        }
        return new ArrayList<RevocationToken<R>>(allTokens);
    }

    public List<EncapsulatedRevocationTokenIdentifier<R>> getAllRevocationBinaries() {
        HashSet<EncapsulatedRevocationTokenIdentifier<R>> allBinaries = new HashSet<EncapsulatedRevocationTokenIdentifier<R>>();
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            allBinaries.addAll(revocationSource.getAllRevocationBinaries());
        }
        return new ArrayList<EncapsulatedRevocationTokenIdentifier<R>>(allBinaries);
    }

    public EncapsulatedRevocationTokenIdentifier<R> findBinaryForReference(RevocationRef<R> reference) {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            EncapsulatedRevocationTokenIdentifier<R> tokenIdentifier = revocationSource.findBinaryForReference(reference);
            if (tokenIdentifier == null) continue;
            return tokenIdentifier;
        }
        return null;
    }

    public boolean isOrphan(RevocationRef<R> reference) {
        for (OfflineRevocationSource<R> revocationSource : this.sources) {
            if (revocationSource.isOrphan(reference)) continue;
            return false;
        }
        return true;
    }

    public int getNumberOfSources() {
        return this.sources.size();
    }
}

