/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateSourceEntity;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ListCertificateSource
implements CertificateSource {
    private static final long serialVersionUID = -7790810642120721289L;
    private List<CertificateSource> sources = new ArrayList<CertificateSource>();

    public ListCertificateSource() {
    }

    public ListCertificateSource(CertificateSource certificateSource) {
        this.add(certificateSource);
    }

    public ListCertificateSource(List<CertificateSource> certificateSources) {
        this.addAll(certificateSources);
    }

    public void addAll(ListCertificateSource listCertificateSource) {
        if (listCertificateSource != null) {
            this.addAll(listCertificateSource.getSources());
        }
    }

    public void addAll(List<CertificateSource> certificateSources) {
        if (certificateSources != null) {
            for (CertificateSource certificateSource : certificateSources) {
                this.add(certificateSource);
            }
        }
    }

    public boolean add(CertificateSource certificateSource) {
        if (certificateSource != null && !this.sources.contains(certificateSource)) {
            return this.sources.add(certificateSource);
        }
        return false;
    }

    public List<CertificateSource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public boolean areAllCertSourcesTrusted() {
        for (CertificateSource certificateSource : this.sources) {
            if (certificateSource.getCertificateSourceType().isTrusted()) continue;
            return false;
        }
        return true;
    }

    public boolean containsTrustedCertSources() {
        for (CertificateSource certificateSource : this.sources) {
            if (!certificateSource.getCertificateSourceType().isTrusted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CertificateToken addCertificate(CertificateToken certificate) {
        throw new UnsupportedOperationException("Cannot add a new certificate to a ListCertificateSource!");
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        throw new UnsupportedOperationException("getCertificateSourceType() method is not supported in ListCertificateSource! Use getCertificateSourceType(CertificateToken certificate) method instead.");
    }

    @Override
    public List<CertificateToken> getCertificates() {
        HashSet<CertificateToken> allTokens = new HashSet<CertificateToken>();
        for (CertificateSource certificateSource : this.sources) {
            allTokens.addAll(certificateSource.getCertificates());
        }
        return new ArrayList<CertificateToken>(allTokens);
    }

    @Override
    public boolean isTrusted(CertificateToken certificateToken) {
        for (CertificateSource source : this.sources) {
            if (!source.isTrusted(certificateToken)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTrustedAtTime(CertificateToken certificateToken, Date controlTime) {
        for (CertificateSource source : this.sources) {
            if (!source.isTrustedAtTime(certificateToken, controlTime)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKnown(CertificateToken certificateToken) {
        for (CertificateSource source : this.sources) {
            if (!source.isKnown(certificateToken)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllSelfSigned() {
        for (CertificateSource certificateSource : this.sources) {
            if (certificateSource.isAllSelfSigned()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCertificateSourceEqual(CertificateSource certificateSource) {
        return new HashSet<CertificateToken>(this.getCertificates()).equals(new HashSet<CertificateToken>(certificateSource.getCertificates()));
    }

    @Override
    public boolean isCertificateSourceEquivalent(CertificateSource certificateSource) {
        return new HashSet<CertificateSourceEntity>(this.getEntities()).equals(new HashSet<CertificateSourceEntity>(certificateSource.getEntities()));
    }

    public Set<CertificateSourceType> getCertificateSourceType(CertificateToken certificateToken) {
        HashSet<CertificateSourceType> result = new HashSet<CertificateSourceType>();
        for (CertificateSource source : this.sources) {
            if (!source.isKnown(certificateToken)) continue;
            result.add(source.getCertificateSourceType());
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getByEntityKey(EntityIdentifier entityKey) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByEntityKey(entityKey));
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getByPublicKey(PublicKey publicKey) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByPublicKey(publicKey));
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getBySki(byte[] ski) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getBySki(ski));
        }
        return result;
    }

    @Override
    public Set<CertificateToken> findTokensFromCertRef(CertificateRef certificateRef) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.findTokensFromCertRef(certificateRef));
        }
        return result;
    }

    @Override
    public List<CertificateSourceEntity> getEntities() {
        HashSet<CertificateSourceEntity> allEntities = new HashSet<CertificateSourceEntity>();
        for (CertificateSource certificateSource : this.sources) {
            allEntities.addAll(certificateSource.getEntities());
        }
        return new ArrayList<CertificateSourceEntity>(allEntities);
    }

    @Override
    public Set<CertificateToken> getBySubject(X500PrincipalHelper subject) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getBySubject(subject));
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getBySignerIdentifier(SignerIdentifier signerIdentifier) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getBySignerIdentifier(signerIdentifier));
        }
        return result;
    }

    @Override
    public Set<CertificateToken> getByCertificateDigest(Digest digest) {
        HashSet<CertificateToken> result = new HashSet<CertificateToken>();
        for (CertificateSource source : this.sources) {
            result.addAll(source.getByCertificateDigest(digest));
        }
        return result;
    }

    public int getNumberOfSources() {
        return this.sources.size();
    }

    public int getNumberOfCertificates() {
        return this.getCertificates().size();
    }

    public int getNumberOfEntities() {
        return this.getEntities().size();
    }
}

