/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import java.util.Objects;

public class CounterSignatureScope
extends SignatureScope {
    private static final long serialVersionUID = 8599151632129217473L;
    protected AdvancedSignature masterSignature;

    public CounterSignatureScope(AdvancedSignature masterSignature, DSSDocument originalDocument) {
        super(originalDocument);
        Objects.requireNonNull(masterSignature, "Master signature cannot be null!");
        this.masterSignature = masterSignature;
    }

    public String getName(TokenIdentifierProvider tokenIdentifierProvider) {
        return this.getMasterSignatureId(tokenIdentifierProvider);
    }

    public String getDescription(TokenIdentifierProvider tokenIdentifierProvider) {
        return String.format("Master signature with Id : %s", this.getMasterSignatureId(tokenIdentifierProvider));
    }

    private String getMasterSignatureId(TokenIdentifierProvider tokenIdentifierProvider) {
        return tokenIdentifierProvider.getIdAsString((IdentifierBasedObject)this.masterSignature);
    }

    public SignatureScopeType getType() {
        return SignatureScopeType.COUNTER_SIGNATURE;
    }
}

