/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.validation.scope;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.utils.Utils;

public abstract class AbstractSignatureScopeFinder {
    protected AbstractSignatureScopeFinder() {
    }

    protected boolean isASiCSArchive(AdvancedSignature advancedSignature) {
        return Utils.isCollectionNotEmpty(advancedSignature.getContainerContents());
    }

    protected boolean isASiCEArchive(AdvancedSignature advancedSignature) {
        return advancedSignature.getManifestFile() != null;
    }

    protected DSSDocument createInMemoryDocument(byte[] binaries) {
        return new InMemoryDocument(binaries);
    }

    protected DSSDocument createDigestDocument(Digest digest) {
        if (digest != null && digest.getAlgorithm() != null && digest.getValue() != null) {
            return new DigestDocument(digest.getAlgorithm(), Utils.toBase64((byte[])digest.getValue()));
        }
        return null;
    }
}

