/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.MultipleRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RepositoryRevocationSource<R extends Revocation>
implements RevocationSource<R>,
MultipleRevocationSource<R> {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRevocationSource.class);
    private static final long serialVersionUID = 8116937707098957391L;
    protected RevocationSource<R> proxiedSource;
    private Long defaultNextUpdateDelay;
    private Long maxNextUpdateDelay;
    private boolean removeExpired = true;

    protected RepositoryRevocationSource() {
    }

    protected abstract List<String> initRevocationTokenKeys(CertificateToken var1);

    protected abstract List<RevocationToken<R>> findRevocations(String var1, CertificateToken var2, CertificateToken var3);

    protected abstract void insertRevocation(String var1, RevocationToken<R> var2);

    protected abstract void updateRevocation(String var1, RevocationToken<R> var2);

    protected abstract void removeRevocation(String var1);

    public void setDefaultNextUpdateDelay(Long defaultNextUpdateDelay) {
        this.defaultNextUpdateDelay = defaultNextUpdateDelay == null ? null : Long.valueOf(defaultNextUpdateDelay * 1000L);
    }

    public void setMaxNextUpdateDelay(Long maxNextUpdateDelay) {
        this.maxNextUpdateDelay = maxNextUpdateDelay == null ? null : Long.valueOf(maxNextUpdateDelay * 1000L);
    }

    public void setProxySource(RevocationSource<R> proxiedSource) {
        this.proxiedSource = proxiedSource;
    }

    public void setRemoveExpired(boolean removeExpired) {
        this.removeExpired = removeExpired;
    }

    @Override
    public RevocationToken<R> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationToken(certificateToken, issuerCertificateToken, false);
    }

    public RevocationToken<R> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        List<RevocationToken<R>> revocationTokens = this.getRevocationTokens(certificateToken, issuerCertificateToken, forceRefresh);
        if (Utils.isCollectionNotEmpty(revocationTokens)) {
            if (Utils.collectionSize(revocationTokens) == 1) {
                return revocationTokens.iterator().next();
            }
            LOG.info("More than one revocation token has been found for certificate with Id '{}'. Return the latest revocation data.", (Object)certificateToken.getDSSIdAsString());
            return this.getLatestRevocationData(revocationTokens);
        }
        return null;
    }

    @Override
    public List<RevocationToken<R>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return this.getRevocationTokens(certificateToken, issuerCertificateToken, false);
    }

    public List<RevocationToken<R>> getRevocationTokens(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        if (certificateToken == null || issuerCertificateToken == null) {
            LOG.warn("Certificate token or issuer's certificate token is null. Cannot get a revocation token!");
            return null;
        }
        Collection<String> keys = this.initRevocationTokenKeys(certificateToken);
        if (forceRefresh) {
            LOG.info("Cache is skipped to retrieve the revocation token for certificate with Id '{}'", (Object)certificateToken.getDSSIdAsString());
        } else {
            Map<String, List<RevocationToken<R>>> cachedRevocationTokensMap = this.extractRevocationFromCacheSource(certificateToken, issuerCertificateToken, keys);
            keys = cachedRevocationTokensMap.keySet();
            if (Utils.isMapNotEmpty(cachedRevocationTokensMap)) {
                return cachedRevocationTokensMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
        }
        RevocationToken<R> revocationToken = this.extractAndInsertRevocationTokenFromProxiedSource(certificateToken, issuerCertificateToken, keys);
        if (revocationToken != null) {
            return Collections.singletonList(revocationToken);
        }
        return Collections.emptyList();
    }

    private Map<String, List<RevocationToken<R>>> extractRevocationFromCacheSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, Collection<String> keys) {
        HashMap<String, List<RevocationToken<R>>> result = new HashMap<String, List<RevocationToken<R>>>();
        for (String key : keys) {
            List<RevocationToken<R>> revocationTokens = this.findRevocations(key, certificateToken, issuerCertificateToken);
            if (!Utils.isCollectionNotEmpty(revocationTokens)) continue;
            List freshRevocationData = revocationTokens.stream().filter(r -> this.isNotExpired((RevocationToken<R>)((Object)r), issuerCertificateToken)).collect(Collectors.toList());
            if (Utils.isCollectionNotEmpty(freshRevocationData)) {
                result.put(key, freshRevocationData);
                continue;
            }
            LOG.debug("Revocation token is expired in the cache for certificate with Id '{}'", (Object)certificateToken.getDSSIdAsString());
            if (!this.removeExpired) continue;
            this.removeRevocation(key);
        }
        if (Utils.isMapNotEmpty(result)) {
            LOG.info("Revocation token for certificate with Id '{}' has been loaded from the cache", (Object)certificateToken.getDSSIdAsString());
        }
        return result;
    }

    private RevocationToken<R> getLatestRevocationData(Collection<RevocationToken<R>> revocationTokens) {
        RevocationToken<R> latestRevocationData = null;
        if (Utils.isCollectionNotEmpty(revocationTokens)) {
            for (RevocationToken<R> revocationToken : revocationTokens) {
                if (latestRevocationData != null && (revocationToken.getThisUpdate() == null || !latestRevocationData.getThisUpdate().before(revocationToken.getThisUpdate()))) continue;
                latestRevocationData = revocationToken;
            }
        }
        return latestRevocationData;
    }

    private RevocationToken<R> extractAndInsertRevocationTokenFromProxiedSource(CertificateToken certificateToken, CertificateToken issuerCertificateToken, Collection<String> keys) {
        if (this.proxiedSource == null) {
            LOG.warn("Proxied revocation source is not initialized for the called RevocationSource!");
            return null;
        }
        RevocationToken<R> revocationToken = this.proxiedSource.getRevocationToken(certificateToken, issuerCertificateToken);
        if (revocationToken != null) {
            if (revocationToken.isValid()) {
                String sourceUrl = this.getRevocationSourceUrl(certificateToken, revocationToken);
                if (sourceUrl == null) {
                    LOG.warn("Not able to find revocation source URL for certificate '{}'. Revocation will not be added to the cache", (Object)certificateToken.getDSSIdAsString());
                    return revocationToken;
                }
                String revocationTokenKey = this.getRevocationTokenKey(certificateToken, sourceUrl);
                if (!keys.contains(revocationTokenKey)) {
                    this.insertRevocation(revocationTokenKey, revocationToken);
                    LOG.info("Revocation token for certificate '{}' is added into the cache", (Object)certificateToken.getDSSIdAsString());
                } else {
                    this.updateRevocation(revocationTokenKey, revocationToken);
                    LOG.info("Revocation token for certificate '{}' is updated in the cache", (Object)certificateToken.getDSSIdAsString());
                }
            } else {
                LOG.warn("The extracted revocation token with Id '{}' is invalid! Reason: {}", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getInvalidityReason());
            }
        }
        return revocationToken;
    }

    protected String getRevocationSourceUrl(CertificateToken certificateToken, RevocationToken<R> revocationToken) {
        String sourceURL = revocationToken.getSourceURL();
        if (sourceURL == null) {
            List<String> urls = this.getRevocationAccessUrls(certificateToken);
            if (urls.size() == 0) {
                LOG.warn("No revocation distribution points have been found for this certificate Token with ID {} ", (Object)certificateToken.getDSSIdAsString());
            } else if (urls.size() == 1) {
                sourceURL = urls.get(0);
            } else {
                sourceURL = urls.get(0);
                LOG.debug("There are multiple revocation distribution points for certificate token with ID {}, the first url will be used as Jdbc revocation source key", (Object)certificateToken.getDSSIdAsString());
            }
        }
        return sourceURL;
    }

    protected abstract List<String> getRevocationAccessUrls(CertificateToken var1);

    protected abstract String getRevocationTokenKey(CertificateToken var1, String var2);

    private boolean isNotExpired(RevocationToken<R> revocationToken, CertificateToken certificateTokenIssuer) {
        Date validationDate = new Date();
        Date nextUpdate = revocationToken.getNextUpdate();
        if (nextUpdate == null) {
            CertificateToken revocationIssuer = revocationToken.getIssuerCertificateToken();
            if (revocationIssuer == null) {
                revocationIssuer = certificateTokenIssuer;
            }
            if (!revocationIssuer.isValidOn(validationDate)) {
                return false;
            }
        }
        Date thisUpdate = revocationToken.getThisUpdate();
        if (nextUpdate == null && this.defaultNextUpdateDelay != null && thisUpdate != null) {
            nextUpdate = new Date(thisUpdate.getTime() + this.defaultNextUpdateDelay);
        }
        if (nextUpdate != null) {
            Date maxNextUpdate;
            if (this.maxNextUpdateDelay != null && thisUpdate != null && nextUpdate.after(maxNextUpdate = new Date(thisUpdate.getTime() + this.maxNextUpdateDelay))) {
                nextUpdate = maxNextUpdate;
            }
            return nextUpdate.after(validationDate);
        }
        return false;
    }
}

