/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.client.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class MaxSizeInputStream
extends FilterInputStream {
    private final int maxSize;
    private final String url;
    private int count = 0;

    public MaxSizeInputStream(InputStream wrappedStream, int maxSize, String url) {
        super(wrappedStream);
        Objects.requireNonNull(wrappedStream, "InputStream shall be provided!");
        this.url = url;
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.count;
            this.checkSize();
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            this.count += read;
            this.checkSize();
        }
        return read;
    }

    private void checkSize() throws IOException {
        if (this.maxSize != 0 && this.count > this.maxSize) {
            throw new IOException("Cannot fetch data limit=" + this.maxSize + ", url=" + this.url);
        }
    }
}

