/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.CertificateExtensionsUtils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlQuery;
import eu.europa.esig.dss.spi.client.jdbc.query.SqlSelectQuery;
import eu.europa.esig.dss.spi.client.jdbc.record.SqlRecord;
import eu.europa.esig.dss.spi.exception.DSSExternalResourceException;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;

public class JdbcCacheOCSPSource
extends JdbcRevocationSource<OCSP>
implements OCSPSource {
    private static final long serialVersionUID = 10480458323923489L;
    private static final SqlQuery SQL_INIT_CHECK_EXISTENCE = SqlQuery.createQuery((String)"SELECT COUNT(*) FROM CACHED_OCSP");
    private static final SqlQuery SQL_INIT_CREATE_TABLE = SqlQuery.createQuery((String)"CREATE TABLE CACHED_OCSP (ID VARCHAR(100), DATA BLOB, LOC VARCHAR(200))");
    private static final SqlQuery SQL_FIND_INSERT = SqlQuery.createQuery((String)"INSERT INTO CACHED_OCSP (ID, DATA, LOC) VALUES (?, ?, ?)");
    private static final SqlQuery SQL_FIND_UPDATE = SqlQuery.createQuery((String)"UPDATE CACHED_OCSP SET DATA = ?, LOC = ? WHERE ID = ?");
    private static final SqlQuery SQL_FIND_REMOVE = SqlQuery.createQuery((String)"DELETE FROM CACHED_OCSP WHERE ID = ?");
    private static final SqlQuery SQL_DROP_TABLE = SqlQuery.createQuery((String)"DROP TABLE CACHED_OCSP");
    private static final SqlSelectQuery SQL_FIND_QUERY = new SqlSelectQuery("SELECT * FROM CACHED_OCSP WHERE ID = ?"){

        public SqlOCSPResponse getRecord(ResultSet rs) throws SQLException {
            SqlOCSPResponse response = new SqlOCSPResponse();
            response.id = rs.getString("ID");
            response.ocspBinary = rs.getBytes("DATA");
            response.ocspUrl = rs.getString("LOC");
            return response;
        }
    };

    protected SqlQuery getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    protected SqlQuery getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    protected SqlQuery getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    protected SqlQuery getInsertRevocationTokenEntryQuery() {
        return SQL_FIND_INSERT;
    }

    protected SqlQuery getUpdateRevocationTokenEntryQuery() {
        return SQL_FIND_UPDATE;
    }

    protected SqlQuery getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    protected SqlSelectQuery getRevocationDataExtractQuery() {
        return SQL_FIND_QUERY;
    }

    protected final List<String> initRevocationTokenKeys(CertificateToken certificateToken) {
        return DSSRevocationUtils.getOcspRevocationTokenKeys((CertificateToken)certificateToken);
    }

    protected RevocationToken<OCSP> buildRevocationTokenFromResult(SqlRecord response, CertificateToken certificateToken, CertificateToken issuerCert) throws DSSExternalResourceException {
        try {
            SqlOCSPResponse ocspResponse = (SqlOCSPResponse)response;
            OCSPResp ocspResp = new OCSPResp(ocspResponse.ocspBinary);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse((BasicOCSPResp)basicResponse, (CertificateToken)certificateToken, (CertificateToken)issuerCert);
            OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerCert);
            ocspToken.setSourceURL(ocspResponse.ocspUrl);
            ocspToken.setExternalOrigin(RevocationOrigin.CACHED);
            return ocspToken;
        }
        catch (IOException | OCSPException e) {
            throw new DSSExternalResourceException(String.format("An error occurred during an attempt to obtain a revocation token. Reason : %s", e.getMessage()), e);
        }
    }

    protected void insertRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.getJdbcCacheConnector().execute(this.getInsertRevocationTokenEntryQuery(), new Object[]{revocationKey, token.getEncoded(), token.getSourceURL()});
    }

    protected void updateRevocation(String revocationKey, RevocationToken<OCSP> token) {
        this.getJdbcCacheConnector().execute(this.getUpdateRevocationTokenEntryQuery(), new Object[]{token.getEncoded(), token.getSourceURL(), revocationKey});
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }

    protected List<String> getRevocationAccessUrls(CertificateToken certificateToken) {
        return CertificateExtensionsUtils.getOCSPAccessUrls((CertificateToken)certificateToken);
    }

    protected String getRevocationTokenKey(CertificateToken certificateToken, String urlString) {
        return DSSRevocationUtils.getOcspRevocationKey((CertificateToken)certificateToken, (String)urlString);
    }

    protected static class SqlOCSPResponse
    implements SqlRecord {
        protected String id;
        protected byte[] ocspBinary;
        protected String ocspUrl;

        protected SqlOCSPResponse() {
        }
    }
}

