/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.QCType;
import java.util.Objects;

public enum QCTypeEnum implements QCType
{
    QCT_ESIGN("qc-type-esign", "0.4.0.1862.1.6.1"),
    QCT_ESEAL("qc-type-eseal", "0.4.0.1862.1.6.2"),
    QCT_WEB("qc-type-web", "0.4.0.1862.1.6.3");

    private final String description;
    private final String oid;

    private QCTypeEnum(String description, String oid) {
        this.description = description;
        this.oid = oid;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static QCTypeEnum forLabel(String description) {
        Objects.requireNonNull(description, "Description label cannot be null!");
        for (QCTypeEnum qcType : QCTypeEnum.values()) {
            if (!description.equals(qcType.description)) continue;
            return qcType;
        }
        return null;
    }
}

