/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.signature.resources.DSSResourcesHandlerBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509AttributeCertificateHolder;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.util.Store;

public interface ICMSUtils {
    public CMS parseToCMS(DSSDocument var1);

    public CMS parseToCMS(byte[] var1);

    public DSSDocument writeToDSSDocument(CMS var1, DSSResourcesHandlerBuilder var2);

    public SignerInformation recomputeSignerInformation(CMS var1, SignerId var2, DigestCalculatorProvider var3, DSSResourcesHandlerBuilder var4) throws CMSException;

    public CMS replaceSigners(CMS var1, SignerInformationStore var2);

    public CMS replaceCertificatesAndCRLs(CMS var1, Store<X509CertificateHolder> var2, Store<X509AttributeCertificateHolder> var3, Store<X509CRLHolder> var4, Store<?> var5, Store<?> var6);

    public CMS populateDigestAlgorithmSet(CMS var1, Collection<AlgorithmIdentifier> var2);

    public CMS toCMS(TimeStampToken var1);

    public String getContentInfoEncoding(CMS var1);

    public void writeSignedDataDigestAlgorithmsEncoded(CMS var1, OutputStream var2) throws IOException;

    public void writeContentInfoEncoded(CMS var1, OutputStream var2) throws IOException;

    public void writeSignedDataCertificatesEncoded(CMS var1, OutputStream var2) throws IOException;

    public void writeSignedDataCRLsEncoded(CMS var1, OutputStream var2) throws IOException;

    public void writeSignedDataSignerInfosEncoded(CMS var1, OutputStream var2) throws IOException;

    public CMSTypedData toCMSEncapsulatedContent(DSSDocument var1);

    public DSSResourcesHandlerBuilder getDSSResourcesHandlerBuilder(DSSResourcesHandlerBuilder var1);

    public SignerInformation replaceUnsignedAttributes(SignerInformation var1, AttributeTable var2);

    public void assertATSv2AugmentationSupported();

    public void assertEvidenceRecordEmbeddingSupported();
}

