/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms;

import eu.europa.esig.dss.enumerations.MimeTypeEnum;
import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.cms.CMSSignedData;

public class CMSSignedDocument
extends CommonDocument {
    private static final long serialVersionUID = 1413370170096318058L;
    protected CMSSignedData signedData;

    public CMSSignedDocument(CMSSignedData data) {
        this(data, null);
    }

    public CMSSignedDocument(CMSSignedData data, String name) {
        Objects.requireNonNull(data, "The CMSSignedData cannot be null");
        this.signedData = data;
        this.name = name;
        this.mimeType = MimeTypeEnum.PKCS7;
    }

    public InputStream openStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    public CMSSignedData getCMSSignedData() {
        return this.signedData;
    }

    public byte[] getBytes() {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.writeTo(output);
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(String.format("An error occurred while reading CMSSignedData binaries : %s", e.getMessage()), (Throwable)e);
            }
        }
        output.close();
        return byArray;
    }

    public void writeTo(OutputStream stream) throws IOException {
        ASN1OutputStream asn1OutputStream = ASN1OutputStream.create((OutputStream)stream, (String)"DL");
        asn1OutputStream.writeObject((ASN1Encodable)this.signedData.toASN1Structure());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CMSSignedDocument that = (CMSSignedDocument)((Object)o);
        if ((this.signedData == null || that.signedData == null) && this.signedData != that.signedData) {
            return false;
        }
        return this.signedData == null || Objects.equals(this.signedData.toASN1Structure(), that.signedData.toASN1Structure());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.signedData.toASN1Structure());
        return result;
    }
}

