/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cms.object;

import eu.europa.esig.dss.cms.AbstractCMSGenerator;
import eu.europa.esig.dss.cms.CMS;
import eu.europa.esig.dss.cms.CMSUtils;
import eu.europa.esig.dss.cms.object.CMSSignedDataObject;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import java.util.Collection;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;

public class CMSObjectGenerator
extends AbstractCMSGenerator {
    public CMS generate() {
        try {
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSignerInfoGenerator(this.signerInfoGenerator);
            generator.addCertificates(this.certificateStore);
            if (this.signers != null) {
                generator.addSigners(this.signers);
            }
            if (this.attributeCertificates != null) {
                generator.addAttributeCertificates(this.attributeCertificates);
            }
            if (this.crls != null) {
                generator.addCRLs(this.crls);
            }
            if (this.ocspBasicStore != null) {
                generator.addOtherRevocationInfo(OCSPObjectIdentifiers.id_pkix_ocsp_basic, this.ocspBasicStore);
            }
            if (this.ocspResponsesStore != null) {
                generator.addOtherRevocationInfo(CMSObjectIdentifiers.id_ri_ocsp_response, this.ocspResponsesStore);
            }
            CMSTypedData contentToBeSigned = CMSUtils.toCMSEncapsulatedContent((DSSDocument)this.toBeSignedDocument);
            CMSSignedData cmsSignedData = generator.generate(contentToBeSigned, this.encapsulate);
            return CMSUtils.populateDigestAlgorithmSet((CMS)new CMSSignedDataObject(cmsSignedData), (Collection)this.digestAlgorithmIDs);
        }
        catch (CMSException e) {
            throw new DSSException(String.format("Unable to build a CMSSignedData. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }
}

