/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.util;

import edu.ksu.canvas.util.HttpParameterBuilder;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CanvasURLBuilder {
    private static final Logger LOG = Logger.getLogger(CanvasURLBuilder.class);

    public static String buildCanvasUrl(String canvasBaseUrl, int canvasAPIVersion, String canvasMethod, Map<String, List<String>> parameters) {
        canvasMethod = CanvasURLBuilder.removeForwardSlashIfExists(canvasMethod);
        String url = canvasBaseUrl + "/api/v" + canvasAPIVersion + "/" + canvasMethod;
        String finalUrl = url + HttpParameterBuilder.buildParameters(parameters);
        LOG.debug((Object)("Built Canvas url - " + finalUrl));
        return finalUrl;
    }

    private static String removeForwardSlashIfExists(String canvasMethod) {
        int beginIndex = canvasMethod.startsWith("/") ? 1 : 0;
        int endIndex = canvasMethod.endsWith("/") ? canvasMethod.length() - 1 : canvasMethod.length();
        return canvasMethod.substring(beginIndex, endIndex);
    }
}

