/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.List;

public class ListActiveCoursesInAccountOptions
extends BaseOptions {
    private String accountId;

    public ListActiveCoursesInAccountOptions(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public ListActiveCoursesInAccountOptions withEnrollments(Boolean enrollments) {
        this.addSingleItem("with_enrollments", enrollments.toString());
        return this;
    }

    public ListActiveCoursesInAccountOptions withEnrollmentTypes(List<EnrollmentType> enrollmentTypes) {
        this.addEnumList("enrollment_type[]", enrollmentTypes);
        return this;
    }

    public ListActiveCoursesInAccountOptions onlyPublished(Boolean published) {
        this.addSingleItem("published", published.toString());
        return this;
    }

    public ListActiveCoursesInAccountOptions onlyCompleted(Boolean completed) {
        this.addSingleItem("published", completed.toString());
        return this;
    }

    public ListActiveCoursesInAccountOptions taughtByTeachers(List<String> teacherList) {
        this.optionsMap.put("by_teachers[]", teacherList);
        return this;
    }

    public ListActiveCoursesInAccountOptions inSubaccount(List<String> accountList) {
        this.optionsMap.put("by_subaccounts[]", accountList);
        return this;
    }

    public ListActiveCoursesInAccountOptions inState(List<State> stateList) {
        this.addEnumList("state[]", stateList);
        return this;
    }

    public ListActiveCoursesInAccountOptions addEnrollmentTermId(String enrollmentTermId) {
        this.addSingleItem("enrollment_term_id", enrollmentTermId);
        return this;
    }

    public ListActiveCoursesInAccountOptions searchTerm(String searchTerm) {
        if (searchTerm == null || searchTerm.length() < 3) {
            throw new IllegalArgumentException("Search term must be at least 3 characters");
        }
        this.addSingleItem("search_term", searchTerm);
        return this;
    }

    public ListActiveCoursesInAccountOptions includes(List<Include> includes) {
        this.addEnumList("include[]", includes);
        return this;
    }

    public static enum Include {
        SYLLABUS_BODY,
        TERM,
        COURSE_PROGRESS,
        STORAGE_QUOTA_USED_MB,
        TOTAL_STUDENTS,
        TEACHERS;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum State {
        CREATED,
        CLAIMED,
        AVAILABLE,
        COMPLETED,
        DELETED,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnrollmentType {
        STUDENT,
        TEACHER,
        TA,
        OBSERVER,
        DESIGNER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

