/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.List;

public class GetEnrollmentOptions
extends BaseOptions {
    private String objectId;

    public GetEnrollmentOptions(String objectId) {
        this.objectId = objectId;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public GetEnrollmentOptions type(List<EnrollmentType> enrollmentTypes) {
        this.addEnumList("type[]", enrollmentTypes);
        return this;
    }

    public GetEnrollmentOptions role(List<String> roles) {
        this.optionsMap.put("role[]", roles);
        return this;
    }

    public GetEnrollmentOptions state(List<EnrollmentState> enrollmentStates) {
        this.addEnumList("state[]", enrollmentStates);
        return this;
    }

    public GetEnrollmentOptions include(List<Include> includes) {
        this.addEnumList("include[]", includes);
        return this;
    }

    public GetEnrollmentOptions userId(String userId) {
        this.addSingleItem("user_id", userId);
        return this;
    }

    public GetEnrollmentOptions gradingPeriodId(Integer gradingPeriod) {
        this.addSingleItem("grading_period_id", gradingPeriod.toString());
        return this;
    }

    public GetEnrollmentOptions sisAccountId(List<String> sisAccountIds) {
        this.optionsMap.put("sis_account_id[]", sisAccountIds);
        return this;
    }

    public GetEnrollmentOptions sisCourseId(List<String> sisCourseIds) {
        this.optionsMap.put("sis_course_id[]", sisCourseIds);
        return this;
    }

    public GetEnrollmentOptions sisSectionId(List<String> sisSectionIds) {
        this.optionsMap.put("sis_section_id[]", sisSectionIds);
        return this;
    }

    public GetEnrollmentOptions sisUserId(List<String> sisUserIds) {
        this.optionsMap.put("sis_user_id[]", sisUserIds);
        return this;
    }

    public static enum Include {
        AVATAR_URL,
        GROUP_IDS,
        LOCKED,
        OBSERVED_USERS,
        CAN_BE_REMOVED;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnrollmentState {
        ACTIVE,
        INVITED,
        CREATION_PENDING,
        DELETED,
        REJECTED,
        COMPLETED,
        INACTIVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnrollmentType {
        STUDENT("StudentEnrollment"),
        TEACHER("TeacherEnrollment"),
        TA("TaEnrollment"),
        DESIGNER("DesignerEnrollment"),
        OBSERVER("ObserverEnrollment");

        private String canvasValue;

        private EnrollmentType(String canvasValue) {
            this.canvasValue = canvasValue;
        }

        public String toString() {
            return this.canvasValue;
        }
    }
}

