/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.requestOptions;

import edu.ksu.canvas.requestOptions.BaseOptions;
import java.util.List;

public class CreateConversationOptions
extends BaseOptions {
    public CreateConversationOptions(List<String> recipients, String bodyText) {
        this.addSingleItem("body", bodyText);
        this.optionsMap.put("recipients[]", recipients);
    }

    public CreateConversationOptions(String recipient, String bodyText) {
        this.addSingleItem("body", bodyText);
        this.addSingleItem("recipients[]", recipient);
    }

    public CreateConversationOptions subject(String subject) {
        this.addSingleItem("subject", subject);
        return this;
    }

    public CreateConversationOptions groupConversation(Boolean groupConversation) {
        this.addSingleItem("group_conversation", groupConversation.toString());
        return this;
    }

    public CreateConversationOptions attachmentIds(List<Integer> attachmentIds) {
        this.addNumberList("attachment_ids[]", attachmentIds);
        return this;
    }

    public CreateConversationOptions mediaCommentId(String mediaCommentId) {
        this.addSingleItem("media_comment_id", mediaCommentId);
        return this;
    }

    public CreateConversationOptions mediaCommentType(MediaCommentType type) {
        this.addSingleItem("media_comment_type", type.toString());
        return this;
    }

    public CreateConversationOptions userNote(Boolean userNote) {
        this.addSingleItem("user_note", userNote.toString());
        return this;
    }

    public CreateConversationOptions mode(Mode mode) {
        this.addSingleItem("mode", mode.toString());
        return this;
    }

    public static enum Mode {
        SYNC,
        ASYNC;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum MediaCommentType {
        AUDIO,
        VIDEO;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

