/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.canvas.net;

import com.google.gson.Gson;
import edu.ksu.canvas.exception.CanvasException;
import edu.ksu.canvas.exception.InvalidOauthTokenException;
import edu.ksu.canvas.exception.ObjectNotFoundException;
import edu.ksu.canvas.exception.UnauthorizedException;
import edu.ksu.canvas.impl.GsonResponseParser;
import edu.ksu.canvas.model.status.CanvasErrorResponse;
import edu.ksu.canvas.net.Response;
import edu.ksu.canvas.net.RestClient;
import edu.ksu.canvas.oauth.OauthToken;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SimpleRestClient
implements RestClient {
    private static final Logger LOG = Logger.getLogger(SimpleRestClient.class);

    @Override
    public Response sendApiGet(@NotNull OauthToken token, @NotNull String url, int connectTimeout, int readTimeout) throws IOException {
        String linkHeaderValue;
        LOG.debug((Object)("Sending GET request to URL: " + url));
        Long beginTime = System.currentTimeMillis();
        Response response = new Response();
        HttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Authorization", "Bearer " + token.getAccessToken());
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        this.checkHeaders(httpResponse, (HttpRequestBase)httpGet);
        response.setContent(this.handleResponse(httpResponse, (HttpRequestBase)httpGet));
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug((Object)("GET call took: " + (endTime - beginTime) + "ms"));
        Header linkHeader = httpResponse.getFirstHeader("Link");
        String string = linkHeaderValue = linkHeader == null ? null : httpResponse.getFirstHeader("Link").getValue();
        if (linkHeaderValue == null) {
            return response;
        }
        List<String> links = Arrays.asList(linkHeaderValue.split(","));
        for (String link : links) {
            if (!link.contains("rel=\"next\"")) continue;
            LOG.debug((Object)"response has more pages");
            String nextLink = link.substring(1, link.indexOf(59) - 1);
            response.setNextLink(nextLink);
        }
        return response;
    }

    @Override
    public Response sendJsonPut(OauthToken token, String url, String json, int connectTimeout, int readTimeout) throws IOException {
        return this.sendJsonPostOrPut(token, url, json, connectTimeout, readTimeout, "PUT");
    }

    @Override
    public Response sendJsonPost(OauthToken token, String url, String json, int connectTimeout, int readTimeout) throws IOException {
        return this.sendJsonPostOrPut(token, url, json, connectTimeout, readTimeout, "POST");
    }

    private Response sendJsonPostOrPut(OauthToken token, String url, String json, int connectTimeout, int readTimeout, String method) throws IOException {
        HttpPost action;
        LOG.debug((Object)("Sending JSON " + method + " to URL: " + url));
        Response response = new Response();
        HttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        if ("POST".equals(method)) {
            action = new HttpPost(url);
        } else if ("PUT".equals(method)) {
            action = new HttpPut(url);
        } else {
            throw new IllegalArgumentException("Method must be either POST or PUT");
        }
        Long beginTime = System.currentTimeMillis();
        action.setHeader("Authorization", "Bearer " + token.getAccessToken());
        StringEntity requestBody = new StringEntity(json, ContentType.APPLICATION_JSON);
        action.setEntity((HttpEntity)requestBody);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)action);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)action);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug((Object)("POST call took: " + (endTime - beginTime) + "ms"));
        return response;
    }

    @Override
    public Response sendApiPost(OauthToken token, String url, Map<String, List<String>> postParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug((Object)("Sending API POST request to URL: " + url));
        Response response = new Response();
        HttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        Long beginTime = System.currentTimeMillis();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(postParameters);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpPost);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug((Object)("POST call took: " + (endTime - beginTime) + "ms"));
        return response;
    }

    @Override
    public Response sendApiPut(OauthToken token, String url, Map<String, List<String>> putParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug((Object)("Sending API PUT request to URL: " + url));
        Response response = new Response();
        HttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        Long beginTime = System.currentTimeMillis();
        HttpPut httpPut = new HttpPut(url);
        httpPut.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(putParameters);
        httpPut.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPut);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpPut);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug((Object)("PUT call took: " + (endTime - beginTime) + "ms"));
        return response;
    }

    @Override
    public Response sendApiDelete(OauthToken token, String url, Map<String, List<String>> deleteParameters, int connectTimeout, int readTimeout) throws InvalidOauthTokenException, IOException {
        LOG.debug((Object)("Sending API DELETE request to URL: " + url));
        Response response = new Response();
        Long beginTime = System.currentTimeMillis();
        HttpClient httpClient = this.createHttpClient(connectTimeout, readTimeout);
        class HttpDeleteWithBody
        extends HttpPost {
            HttpDeleteWithBody() {
            }

            public String getMethod() {
                return "DELETE";
            }
        }
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody();
        httpDelete.setURI(URI.create(url));
        httpDelete.setHeader("Authorization", "Bearer " + token.getAccessToken());
        List<NameValuePair> params = SimpleRestClient.convertParameters(deleteParameters);
        httpDelete.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpDelete);
        String content = this.handleResponse(httpResponse, (HttpRequestBase)httpDelete);
        response.setContent(content);
        response.setResponseCode(httpResponse.getStatusLine().getStatusCode());
        Long endTime = System.currentTimeMillis();
        LOG.debug((Object)("DELETE call took: " + (endTime - beginTime) + "ms"));
        return response;
    }

    private void checkHeaders(HttpResponse httpResponse, HttpRequestBase request) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            if (httpResponse.containsHeader("WWW-Authenticate")) {
                LOG.debug((Object)"User's token is invalid. It might need refreshing");
                throw new InvalidOauthTokenException();
            }
            LOG.error((Object)"User is not authorized to perform this action");
            throw new UnauthorizedException();
        }
        if (statusCode == 404) {
            LOG.error((Object)("Object not found in Canvas. Requested URL: " + request.getURI()));
            throw new ObjectNotFoundException(this.extractErrorMessageFromResponse(httpResponse), String.valueOf(request.getURI()));
        }
        if (statusCode < 200 || statusCode > 299) {
            LOG.error((Object)("HTTP status " + statusCode + " returned from " + request.getURI()));
            throw new CanvasException(this.extractErrorMessageFromResponse(httpResponse), String.valueOf(request.getURI()));
        }
    }

    private String extractErrorMessageFromResponse(HttpResponse response) {
        block4: {
            String contentType = response.getEntity().getContentType().getValue();
            if (contentType.contains("application/json")) {
                Gson gson = GsonResponseParser.getDefaultGsonParser();
                String responseBody = null;
                try {
                    responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    LOG.error((Object)("Body of error response from Canvas: " + responseBody));
                    CanvasErrorResponse errorResponse = (CanvasErrorResponse)gson.fromJson(responseBody, CanvasErrorResponse.class);
                    List<CanvasErrorResponse.ErrorMessage> errors = errorResponse.getErrors();
                    if (errors != null) {
                        return errors.stream().map(e -> e.getMessage()).collect(Collectors.joining(", "));
                    }
                }
                catch (Exception e2) {
                    if (!StringUtils.isNotBlank((CharSequence)responseBody)) break block4;
                    return responseBody;
                }
            }
        }
        return null;
    }

    private String handleResponse(HttpResponse httpResponse, HttpRequestBase request) throws IOException {
        this.checkHeaders(httpResponse, request);
        return new BasicResponseHandler().handleResponse(httpResponse);
    }

    private HttpClient createHttpClient(int connectTimeout, int readTimeout) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams params = httpClient.getParams();
        params.setParameter("http.connection.timeout", (Object)connectTimeout);
        params.setParameter("http.socket.timeout", (Object)readTimeout);
        return httpClient;
    }

    private static List<NameValuePair> convertParameters(Map<String, List<String>> parameterMap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (parameterMap == null) {
            return params;
        }
        for (Map.Entry<String, List<String>> param : parameterMap.entrySet()) {
            String key = param.getKey();
            for (String value : param.getValue()) {
                params.add((NameValuePair)new BasicNameValuePair(key, value));
                LOG.debug((Object)("key " + key + "\t value : " + value));
            }
        }
        return params;
    }
}

